"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LiveQueryDetailsPage = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _kibana = require("../../../common/lib/kibana");
var _layouts = require("../../../components/layouts");
var _use_live_query_details = require("../../../actions/use_live_query_details");
var _use_breadcrumbs = require("../../../common/hooks/use_breadcrumbs");
var _pack_queries_status_table = require("../../../live_queries/form/pack_queries_status_table");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const tableWrapperCss = {
  paddingLeft: '10px'
};
const LiveQueryDetailsPageComponent = () => {
  const {
    actionId
  } = (0, _reactRouterDom.useParams)();
  (0, _use_breadcrumbs.useBreadcrumbs)('live_query_details', {
    liveQueryId: actionId
  });
  const liveQueryListProps = (0, _kibana.useRouterNavigate)('live_queries');
  const [isLive, setIsLive] = (0, _react.useState)(false);
  const {
    data
  } = (0, _use_live_query_details.useLiveQueryDetails)({
    actionId,
    isLive
  });
  const LeftColumn = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "flexStart",
    direction: "column",
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, (0, _extends2.default)({
    iconType: "arrowLeft"
  }, liveQueryListProps, {
    flush: "left",
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.osquery.liveQueryDetails.viewLiveQueriesHistoryTitle",
    defaultMessage: "View live queries history"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h1", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.osquery.liveQueryDetails.pageTitle",
    defaultMessage: "Live query details"
  }))))), [liveQueryListProps]);
  (0, _react.useLayoutEffect)(() => {
    setIsLive(() => !((data === null || data === void 0 ? void 0 : data.status) === 'completed'));
  }, [data === null || data === void 0 ? void 0 : data.status]);
  return /*#__PURE__*/_react.default.createElement(_layouts.WithHeaderLayout, {
    leftColumn: LeftColumn,
    rightColumnGrow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: tableWrapperCss
  }, /*#__PURE__*/_react.default.createElement(_pack_queries_status_table.PackQueriesStatusTable, {
    actionId: actionId,
    data: data === null || data === void 0 ? void 0 : data.queries,
    startDate: data === null || data === void 0 ? void 0 : data['@timestamp'],
    expirationDate: data === null || data === void 0 ? void 0 : data.expiration,
    agentIds: data === null || data === void 0 ? void 0 : data.agents,
    showResultsHeader: true
  })));
};
const LiveQueryDetailsPage = exports.LiveQueryDetailsPage = /*#__PURE__*/_react.default.memo(LiveQueryDetailsPageComponent);