"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AssetDetailsLocatorDefinition = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _rison = _interopRequireDefault(require("@kbn/rison"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ASSET_DETAILS_LOCATOR_ID = 'ASSET_DETAILS_LOCATOR';
class AssetDetailsLocatorDefinition {
  constructor() {
    (0, _defineProperty2.default)(this, "id", ASSET_DETAILS_LOCATOR_ID);
    (0, _defineProperty2.default)(this, "getLocation", async params => {
      const searchPath = _rison.default.encodeUnknown(params._a);
      const assetDetails = _rison.default.encodeUnknown(params.assetDetails);
      return {
        app: 'metrics',
        path: `/detail/${params.assetType}/${params.assetId}?assetDetails=${assetDetails}&_a=${searchPath}`,
        state: {}
      };
    });
  }
}
exports.AssetDetailsLocatorDefinition = AssetDetailsLocatorDefinition;