"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerRoutes = registerRoutes;
var _elasticsearch = require("@elastic/elasticsearch");
var _boom = _interopRequireDefault(require("@hapi/boom"));
var _serverRouteRepository = require("@kbn/server-route-repository");
var _axios = _interopRequireDefault(require("axios"));
var t = _interopRequireWildcard(require("io-ts"));
var _errors = require("../errors");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function registerRoutes({
  config,
  repository,
  core,
  logger,
  dependencies
}) {
  const routes = Object.values(repository);
  const router = core.http.createRouter();
  routes.forEach(route => {
    const {
      endpoint,
      options,
      handler,
      params
    } = route;
    const {
      pathname,
      method
    } = (0, _serverRouteRepository.parseEndpoint)(endpoint);
    router[method]({
      path: pathname,
      validate: _serverRouteRepository.routeValidationObject,
      options
    }, async (context, request, response) => {
      try {
        const decodedParams = (0, _serverRouteRepository.decodeRequestParams)({
          params: request.params,
          body: request.body,
          query: request.query
        }, params !== null && params !== void 0 ? params : t.strict({}));
        const data = await handler({
          config,
          context,
          request,
          logger,
          params: decodedParams,
          dependencies
        });
        if (data === undefined) {
          return response.noContent();
        }
        return response.ok({
          body: data
        });
      } catch (error) {
        if (error instanceof _errors.ObservabilityError) {
          logger.error(error.message);
          return response.customError({
            statusCode: (0, _errors.getHTTPResponseCode)(error),
            body: {
              message: error.message
            }
          });
        }
        if (_axios.default.isAxiosError(error)) {
          var _error$response;
          logger.error(error);
          return response.customError({
            statusCode: ((_error$response = error.response) === null || _error$response === void 0 ? void 0 : _error$response.status) || 500,
            body: {
              message: error.message
            }
          });
        }
        if (_boom.default.isBoom(error)) {
          logger.error(error.output.payload.message);
          return response.customError({
            statusCode: error.output.statusCode,
            body: {
              message: error.output.payload.message
            }
          });
        }
        logger.error(error);
        const opts = {
          statusCode: 500,
          body: {
            message: error.message
          }
        };
        if (error instanceof _elasticsearch.errors.RequestAbortedError) {
          opts.statusCode = 499;
          opts.body.message = 'Client closed request';
        }
        return response.customError(opts);
      }
    });
  });
}