"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ObservabilityPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _common = require("@kbn/cases-plugin/common");
var _server = require("@kbn/core/server");
var _deeplinksObservability = require("@kbn/deeplinks-observability");
var _saved_objects = require("@kbn/files-plugin/server/saved_objects");
var _i18n = require("@kbn/i18n");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _common2 = require("../common");
var _kubernetes_guide_config = require("../common/guided_onboarding/kubernetes_guide_config");
var _alerts = require("../common/locators/alerts");
var _bootstrap_annotations = require("./lib/annotations/bootstrap_annotations");
var _register_rule_types = require("./lib/rules/register_rule_types");
var _get_global_observability_server_route_repository = require("./routes/get_global_observability_server_route_repository");
var _register_routes = require("./routes/register_routes");
var _threshold = require("./saved_objects/threshold");
var _services = require("./services");
var _ui_settings = require("./ui_settings");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const o11yRuleTypes = [_ruleDataUtils.SLO_BURN_RATE_RULE_TYPE_ID, _ruleDataUtils.OBSERVABILITY_THRESHOLD_RULE_TYPE_ID, _ruleDataUtils.ES_QUERY_ID, _ruleDataUtils.ML_ANOMALY_DETECTION_RULE_TYPE_ID, _ruleDataUtils.METRIC_INVENTORY_THRESHOLD_ALERT_TYPE_ID, ...Object.values(_ruleDataUtils.ApmRuleType)];
class ObservabilityPlugin {
  constructor(initContext) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    this.initContext = initContext;
    this.initContext = initContext;
    this.logger = initContext.logger.get();
  }
  setup(core, plugins) {
    var _plugins$guidedOnboar;
    const casesCapabilities = (0, _common.createUICapabilities)();
    const casesApiTags = (0, _common.getApiTags)(_common2.observabilityFeatureId);
    const config = this.initContext.config.get();
    const alertsLocator = plugins.share.url.locators.create(new _alerts.AlertsLocatorDefinition());
    const logsExplorerLocator = plugins.share.url.locators.get(_deeplinksObservability.LOGS_EXPLORER_LOCATOR_ID);
    const alertDetailsContextualInsightsService = new _services.AlertDetailsContextualInsightsService();
    plugins.features.registerKibanaFeature({
      id: _common2.casesFeatureId,
      name: _i18n.i18n.translate('xpack.observability.featureRegistry.linkObservabilityTitle', {
        defaultMessage: 'Cases'
      }),
      order: 1100,
      category: _server.DEFAULT_APP_CATEGORIES.observability,
      app: [_common2.casesFeatureId, 'kibana'],
      catalogue: [_common2.observabilityFeatureId],
      cases: [_common2.observabilityFeatureId],
      privileges: {
        all: {
          api: casesApiTags.all,
          app: [_common2.casesFeatureId, 'kibana'],
          catalogue: [_common2.observabilityFeatureId],
          cases: {
            create: [_common2.observabilityFeatureId],
            read: [_common2.observabilityFeatureId],
            update: [_common2.observabilityFeatureId],
            push: [_common2.observabilityFeatureId]
          },
          savedObject: {
            all: [..._saved_objects.hiddenTypes],
            read: [..._saved_objects.hiddenTypes]
          },
          ui: casesCapabilities.all
        },
        read: {
          api: casesApiTags.read,
          app: [_common2.casesFeatureId, 'kibana'],
          catalogue: [_common2.observabilityFeatureId],
          cases: {
            read: [_common2.observabilityFeatureId]
          },
          savedObject: {
            all: [],
            read: [..._saved_objects.hiddenTypes]
          },
          ui: casesCapabilities.read
        }
      },
      subFeatures: [{
        name: _i18n.i18n.translate('xpack.observability.featureRegistry.deleteSubFeatureName', {
          defaultMessage: 'Delete'
        }),
        privilegeGroups: [{
          groupType: 'independent',
          privileges: [{
            api: casesApiTags.delete,
            id: 'cases_delete',
            name: _i18n.i18n.translate('xpack.observability.featureRegistry.deleteSubFeatureDetails', {
              defaultMessage: 'Delete cases and comments'
            }),
            includeIn: 'all',
            savedObject: {
              all: [..._saved_objects.hiddenTypes],
              read: [..._saved_objects.hiddenTypes]
            },
            cases: {
              delete: [_common2.observabilityFeatureId]
            },
            ui: casesCapabilities.delete
          }]
        }]
      }, {
        name: _i18n.i18n.translate('xpack.observability.featureRegistry.casesSettingsSubFeatureName', {
          defaultMessage: 'Case settings'
        }),
        privilegeGroups: [{
          groupType: 'independent',
          privileges: [{
            id: 'cases_settings',
            name: _i18n.i18n.translate('xpack.observability.featureRegistry.casesSettingsSubFeatureDetails', {
              defaultMessage: 'Edit case settings'
            }),
            includeIn: 'all',
            savedObject: {
              all: [..._saved_objects.hiddenTypes],
              read: [..._saved_objects.hiddenTypes]
            },
            cases: {
              settings: [_common2.observabilityFeatureId]
            },
            ui: casesCapabilities.settings
          }]
        }]
      }]
    });
    let annotationsApiPromise;
    core.uiSettings.register(_ui_settings.uiSettings);
    if (config.annotations.enabled) {
      annotationsApiPromise = (0, _bootstrap_annotations.bootstrapAnnotations)({
        core,
        index: config.annotations.index,
        context: this.initContext
      }).catch(err => {
        const logger = this.initContext.logger.get('annotations');
        logger.warn(err);
        throw err;
      });
    }
    if (config.createO11yGenericFeatureId) {
      plugins.features.registerKibanaFeature({
        id: _common2.observabilityFeatureId,
        name: _i18n.i18n.translate('xpack.observability.nameFeatureTitle', {
          defaultMessage: 'Observability'
        }),
        order: 1000,
        category: _server.DEFAULT_APP_CATEGORIES.observability,
        app: [_common2.observabilityFeatureId],
        catalogue: [_common2.observabilityFeatureId],
        alerting: o11yRuleTypes,
        privileges: {
          all: {
            app: [_common2.observabilityFeatureId],
            catalogue: [_common2.observabilityFeatureId],
            api: ['rac'],
            savedObject: {
              all: [],
              read: []
            },
            alerting: {
              rule: {
                all: o11yRuleTypes
              },
              alert: {
                all: o11yRuleTypes
              }
            },
            ui: ['read', 'write']
          },
          read: {
            app: [_common2.observabilityFeatureId],
            catalogue: [_common2.observabilityFeatureId],
            api: ['rac'],
            savedObject: {
              all: [],
              read: []
            },
            alerting: {
              rule: {
                read: o11yRuleTypes
              },
              alert: {
                read: o11yRuleTypes
              }
            },
            ui: ['read']
          }
        }
      });
    }
    const {
      ruleDataService
    } = plugins.ruleRegistry;
    core.savedObjects.registerType(_threshold.threshold);
    (0, _register_rule_types.registerRuleTypes)(plugins.alerting, core.http.basePath, config, this.logger, {
      alertsLocator,
      logsExplorerLocator
    });
    core.getStartServices().then(([coreStart, pluginStart]) => {
      (0, _register_routes.registerRoutes)({
        core,
        config,
        dependencies: {
          pluginsSetup: {
            ...plugins,
            core
          },
          spaces: pluginStart.spaces,
          ruleDataService,
          assistant: {
            alertDetailsContextualInsightsService
          },
          getRulesClientWithRequest: pluginStart.alerting.getRulesClientWithRequest
        },
        logger: this.logger,
        repository: (0, _get_global_observability_server_route_repository.getObservabilityServerRouteRepository)(config)
      });
    });
    /**
     * Register a config for the observability guide
     */
    (_plugins$guidedOnboar = plugins.guidedOnboarding) === null || _plugins$guidedOnboar === void 0 ? void 0 : _plugins$guidedOnboar.registerGuideConfig(_kubernetes_guide_config.kubernetesGuideId, _kubernetes_guide_config.kubernetesGuideConfig);
    return {
      getAlertDetailsConfig() {
        return config.unsafe.alertDetails;
      },
      getScopedAnnotationsClient: async (...args) => {
        const api = await annotationsApiPromise;
        return api === null || api === void 0 ? void 0 : api.getScopedAnnotationsClient(...args);
      },
      alertDetailsContextualInsightsService,
      alertsLocator
    };
  }
  start(core, plugins) {}
  stop() {}
}
exports.ObservabilityPlugin = ObservabilityPlugin;