"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getElasticsearchMetricQuery = exports.createBoolQuery = exports.calculateCurrentTimeFrame = void 0;
var _moment = _interopRequireDefault(require("moment"));
var _types = require("../../../../../common/custom_threshold_rule/types");
var _get_parsed_filtered_query = require("../../../../utils/get_parsed_filtered_query");
var _create_custom_metrics_aggregations = require("./create_custom_metrics_aggregations");
var _utils = require("../utils");
var _create_bucket_selector = require("./create_bucket_selector");
var _wrap_in_period = require("./wrap_in_period");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const calculateCurrentTimeFrame = (metricParams, timeframe) => {
  const isRateAgg = metricParams.metrics.some(metric => metric.aggType === _types.Aggregators.RATE);
  return {
    ...timeframe,
    start: (0, _moment.default)(timeframe.end).subtract(isRateAgg ? metricParams.timeSize * 2 : metricParams.timeSize, metricParams.timeUnit).valueOf()
  };
};
exports.calculateCurrentTimeFrame = calculateCurrentTimeFrame;
const QueryDslQueryContainerToFilter = queries => {
  return queries.map(query => ({
    meta: {},
    query
  }));
};
const createBoolQuery = (timeframe, timeFieldName, searchConfiguration, additionalQueries = []) => {
  const rangeQuery = {
    range: {
      [timeFieldName]: {
        gte: (0, _moment.default)(timeframe.start).toISOString(),
        lte: (0, _moment.default)(timeframe.end).toISOString()
      }
    }
  };
  const filters = QueryDslQueryContainerToFilter([rangeQuery, ...additionalQueries]);
  return (0, _get_parsed_filtered_query.getSearchConfigurationBoolQuery)(searchConfiguration, filters);
};
exports.createBoolQuery = createBoolQuery;
const getElasticsearchMetricQuery = (metricParams, timeframe, timeFieldName, compositeSize, alertOnGroupDisappear, searchConfiguration, lastPeriodEnd, groupBy, afterKey, fieldsExisted) => {
  // We need to make a timeframe that represents the current timeframe as opposed
  // to the total timeframe (which includes the last period).
  const currentTimeFrame = {
    ...calculateCurrentTimeFrame(metricParams, timeframe),
    timeFieldName
  };
  const metricAggregations = (0, _create_custom_metrics_aggregations.createCustomMetricsAggregations)('aggregatedValue', metricParams.metrics, currentTimeFrame, timeFieldName, metricParams.equation);
  const bucketSelectorAggregations = (0, _create_bucket_selector.createBucketSelector)(metricParams, alertOnGroupDisappear, timeFieldName, groupBy, lastPeriodEnd);
  const currentPeriod = (0, _wrap_in_period.wrapInCurrentPeriod)(currentTimeFrame, metricAggregations);
  const containerIncludesList = ['container.*'];
  const containerExcludesList = ['container.cpu', 'container.memory', 'container.disk', 'container.network'];
  const containerContextAgg = (0, _utils.shouldTermsAggOnContainer)(groupBy) && fieldsExisted && fieldsExisted[_utils.CONTAINER_ID] ? {
    containerContext: {
      terms: {
        field: _utils.CONTAINER_ID,
        size: _utils.NUMBER_OF_DOCUMENTS
      },
      aggs: {
        container: {
          top_hits: {
            size: 1,
            _source: {
              includes: containerIncludesList,
              excludes: containerExcludesList
            }
          }
        }
      }
    }
  } : void 0;
  const includesList = ['host.*', 'labels.*', 'tags', 'cloud.*', 'orchestrator.*'];
  const excludesList = ['host.cpu', 'host.disk', 'host.network'];
  if (!containerContextAgg) {
    includesList.push(...containerIncludesList);
    excludesList.push(...containerExcludesList);
  }
  const additionalContextAgg = (0, _utils.hasAdditionalContext)(groupBy, _utils.validGroupByForContext) ? {
    additionalContext: {
      top_hits: {
        size: 1,
        _source: {
          includes: includesList,
          excludes: excludesList
        }
      }
    }
  } : void 0;
  const aggs = groupBy ? {
    groupings: {
      composite: {
        size: compositeSize,
        sources: Array.isArray(groupBy) ? groupBy.map((field, index) => ({
          [`groupBy${index}`]: {
            terms: {
              field
            }
          }
        })) : [{
          groupBy0: {
            terms: {
              field: groupBy
            }
          }
        }]
      },
      aggs: {
        ...currentPeriod,
        ...bucketSelectorAggregations,
        ...additionalContextAgg,
        ...containerContextAgg
      }
    }
  } : {
    all: {
      filters: {
        filters: {
          all: {
            match_all: {}
          }
        }
      },
      aggs: {
        ...currentPeriod,
        ...bucketSelectorAggregations
      }
    }
  };
  if (aggs.groupings && afterKey) {
    aggs.groupings.composite.after = afterKey;
  }
  const query = createBoolQuery(timeframe, timeFieldName, searchConfiguration);
  return {
    track_total_hits: true,
    query,
    size: 0,
    aggs
  };
};
exports.getElasticsearchMetricQuery = getElasticsearchMetricQuery;