"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createCustomMetricsAggregations = void 0;
var _esQuery = require("@kbn/es-query");
var _lodash = require("lodash");
var _types = require("../../../../../common/custom_threshold_rule/types");
var _create_rate_aggregation = require("./create_rate_aggregation");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createCustomMetricsAggregations = (id, customMetrics, currentTimeFrame, timeFieldName, equation) => {
  const bucketsPath = {};
  const metricAggregations = customMetrics.reduce((acc, metric) => {
    const key = `${id}_${metric.name}`;
    const aggregation = metric.aggType;
    if (aggregation === 'count') {
      bucketsPath[metric.name] = `${key}>_count`;
      return {
        ...acc,
        [key]: {
          filter: metric.filter ? (0, _esQuery.toElasticsearchQuery)((0, _esQuery.fromKueryExpression)(metric.filter)) : {
            match_all: {}
          }
        }
      };
    }
    if (aggregation === _types.Aggregators.P95 || aggregation === _types.Aggregators.P99) {
      bucketsPath[metric.name] = key;
      return {
        ...acc,
        [key]: {
          percentiles: {
            field: metric.field,
            percents: [aggregation === _types.Aggregators.P95 ? 95 : 99],
            keyed: true
          }
        }
      };
    }
    if (aggregation === _types.Aggregators.RATE) {
      bucketsPath[metric.name] = key;
      return {
        ...acc,
        ...(0, _create_rate_aggregation.createRateAggsBuckets)(currentTimeFrame, key, timeFieldName, metric.field || ''),
        ...(0, _create_rate_aggregation.createRateAggsBucketScript)(currentTimeFrame, key)
      };
    }
    if (aggregation && metric.field) {
      bucketsPath[metric.name] = key;
      return {
        ...acc,
        [key]: {
          [aggregation]: {
            field: metric.field
          }
        }
      };
    }
    return acc;
  }, {});
  if ((0, _lodash.isEmpty)(metricAggregations)) {
    return {};
  }
  return {
    ...metricAggregations,
    [id]: {
      bucket_script: {
        buckets_path: bucketsPath,
        script: {
          source: convertEquationToPainless(bucketsPath, equation),
          lang: 'painless'
        }
      }
    }
  };
};
exports.createCustomMetricsAggregations = createCustomMetricsAggregations;
const convertEquationToPainless = (bucketsPath, equation) => {
  const workingEquation = equation || Object.keys(bucketsPath).join(' + ');
  return Object.keys(bucketsPath).reduce((acc, key) => {
    return acc.replaceAll(key, `params.${key}`);
  }, workingEquation);
};