"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildEsQuery = buildEsQuery;
var _esQuery = require("@kbn/es-query");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _common = require("@kbn/data-plugin/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function buildEsQuery({
  timeRange,
  kuery,
  config = {},
  queries = [],
  filters = []
}) {
  const timeFilter = timeRange && (0, _common.getTime)(undefined, timeRange, {
    fieldName: _ruleDataUtils.ALERT_TIME_RANGE
  });
  const filtersToUse = timeFilter ? [timeFilter, ...filters] : filters;
  const kueryFilter = kuery ? [{
    query: kuery,
    language: 'kuery'
  }] : [];
  const queryToUse = [...kueryFilter, ...queries];
  return (0, _esQuery.buildEsQuery)(undefined, queryToUse, filtersToUse, config);
}