"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HeaderActions = HeaderActions;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function HeaderActions({
  isLoading,
  isRuleEditable,
  onDeleteRule,
  onEditRule
}) {
  const [isRuleEditPopoverOpen, setIsRuleEditPopoverOpen] = (0, _react.useState)(false);
  const togglePopover = () => setIsRuleEditPopoverOpen(!isRuleEditPopoverOpen);
  const handleEditRule = () => {
    setIsRuleEditPopoverOpen(false);
    onEditRule();
  };
  const handleRemoveRule = () => {
    setIsRuleEditPopoverOpen(false);
    onDeleteRule();
  };
  return isRuleEditable ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "rowReverse",
    alignItems: "flexStart"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "contextRuleEditMenu",
    isOpen: isRuleEditPopoverOpen,
    closePopover: togglePopover,
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "actions",
      disabled: isLoading,
      fill: true,
      iconSide: "right",
      iconType: "arrowDown",
      onClick: togglePopover
    }, _i18n.i18n.translate('xpack.observability.ruleDetails.actionsButtonLabel', {
      defaultMessage: 'Actions'
    }))
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    alignItems: "flexStart",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "editRuleButton",
    size: "s",
    iconType: "pencil",
    onClick: handleEditRule
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, _i18n.i18n.translate('xpack.observability.ruleDetails.editRule', {
    defaultMessage: 'Edit rule'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "s",
    iconType: "trash",
    color: "danger",
    onClick: handleRemoveRule,
    "data-test-subj": "deleteRuleButton"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, _i18n.i18n.translate('xpack.observability.ruleDetails.deleteRule', {
    defaultMessage: 'Delete rule'
  }))))))) : null;
}