"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertsPage = AlertsPage;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _public2 = require("@kbn/observability-shared-plugin/public");
var _alertsUiShared = require("@kbn/alerts-ui-shared");
var _coreApplicationCommon = require("@kbn/core-application-common");
var _common = require("../../../common");
var _kibana_react = require("../../utils/kibana_react");
var _use_plugin_context = require("../../hooks/use_plugin_context");
var _use_time_buckets = require("../../hooks/use_time_buckets");
var _use_get_filtered_rule_types = require("../../hooks/use_get_filtered_rule_types");
var _use_toast = require("../../hooks/use_toast");
var _rule_stats = require("./components/rule_stats");
var _alert_search_bar = require("../../components/alert_search_bar/alert_search_bar");
var _containers = require("../../components/alert_search_bar/containers");
var _calculate_bucket_size = require("../overview/helpers/calculate_bucket_size");
var _alert_summary_widget = require("../../utils/alert_summary_widget");
var _constants = require("../../../common/constants");
var _header_menu = require("../overview/components/header_menu/header_menu");
var _use_get_available_rules_with_descriptions = require("../../hooks/use_get_available_rules_with_descriptions");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ALERTS_SEARCH_BAR_ID = 'alerts-search-bar-o11y';
const ALERTS_PER_PAGE = 50;
const ALERTS_TABLE_ID = 'xpack.observability.alerts.alert.table';
const DEFAULT_INTERVAL = '60s';
const DEFAULT_DATE_FORMAT = 'YYYY-MM-DD HH:mm';
function InternalAlertsPage() {
  const kibanaServices = (0, _kibana_react.useKibana)().services;
  const {
    charts,
    data: {
      query: {
        timefilter: {
          timefilter: timeFilterService
        }
      }
    },
    http,
    notifications: {
      toasts
    },
    observabilityAIAssistant,
    share: {
      url: {
        locators
      }
    },
    triggersActionsUi: {
      alertsTableConfigurationRegistry,
      getAlertsSearchBar: AlertsSearchBar,
      getAlertsStateTable: AlertsStateTable,
      getAlertSummaryWidget: AlertSummaryWidget
    },
    uiSettings
  } = kibanaServices;
  const {
    ObservabilityPageTemplate,
    observabilityRuleTypeRegistry
  } = (0, _use_plugin_context.usePluginContext)();
  const alertSearchBarStateProps = (0, _containers.useAlertSearchBarStateContainer)(_constants.ALERTS_URL_STORAGE_KEY, {
    replace: false
  });
  const filteredRuleTypes = (0, _use_get_filtered_rule_types.useGetFilteredRuleTypes)();
  const {
    setScreenContext
  } = (observabilityAIAssistant === null || observabilityAIAssistant === void 0 ? void 0 : observabilityAIAssistant.service) || {};
  const ruleTypesWithDescriptions = (0, _use_get_available_rules_with_descriptions.useGetAvailableRulesWithDescriptions)();
  (0, _react.useEffect)(() => {
    return setScreenContext === null || setScreenContext === void 0 ? void 0 : setScreenContext({
      data: ruleTypesWithDescriptions.map(rule => ({
        name: rule.id,
        value: `${rule.name} ${rule.description}`,
        description: `An available rule is ${rule.name}.`
      })),
      starterPrompts: [{
        title: _i18n.i18n.translate('xpack.observability.app.starterPrompts.explainRules.title', {
          defaultMessage: 'Explain'
        }),
        prompt: _i18n.i18n.translate('xpack.observability.app.starterPrompts.explainRules.prompt', {
          defaultMessage: `Can you explain the rule types that are available?`
        }),
        icon: 'sparkles'
      }]
    });
  }, [filteredRuleTypes, ruleTypesWithDescriptions, setScreenContext]);
  const onBrushEnd = brushEvent => {
    const {
      x
    } = brushEvent;
    if (x) {
      const [start, end] = x;
      alertSearchBarStateProps.onRangeFromChange(new Date(start).toISOString());
      alertSearchBarStateProps.onRangeToChange(new Date(end).toISOString());
    }
  };
  const chartProps = {
    baseTheme: charts.theme.useChartsBaseTheme(),
    onBrushEnd
  };
  const [ruleStatsLoading, setRuleStatsLoading] = (0, _react.useState)(false);
  const [ruleStats, setRuleStats] = (0, _react.useState)({
    total: 0,
    disabled: 0,
    muted: 0,
    error: 0,
    snoozed: 0
  });
  const [esQuery, setEsQuery] = (0, _react.useState)();
  const timeBuckets = (0, _use_time_buckets.useTimeBuckets)();
  const bucketSize = (0, _react.useMemo)(() => (0, _calculate_bucket_size.calculateTimeRangeBucketSize)({
    from: alertSearchBarStateProps.rangeFrom,
    to: alertSearchBarStateProps.rangeTo
  }, timeBuckets), [alertSearchBarStateProps.rangeFrom, alertSearchBarStateProps.rangeTo, timeBuckets]);
  const alertSummaryTimeRange = (0, _react.useMemo)(() => (0, _alert_summary_widget.getAlertSummaryTimeRange)({
    from: alertSearchBarStateProps.rangeFrom,
    to: alertSearchBarStateProps.rangeTo
  }, (bucketSize === null || bucketSize === void 0 ? void 0 : bucketSize.intervalString) || DEFAULT_INTERVAL, (bucketSize === null || bucketSize === void 0 ? void 0 : bucketSize.dateFormat) || DEFAULT_DATE_FORMAT),
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [alertSearchBarStateProps.rangeFrom, alertSearchBarStateProps.rangeTo, bucketSize, esQuery]);
  (0, _public2.useBreadcrumbs)([{
    text: _i18n.i18n.translate('xpack.observability.breadcrumbs.alertsLinkText', {
      defaultMessage: 'Alerts'
    })
  }]);
  async function loadRuleStats() {
    setRuleStatsLoading(true);
    try {
      const response = await (0, _public.loadRuleAggregations)({
        http,
        typesFilter: filteredRuleTypes,
        filterConsumers: _constants.observabilityAlertFeatureIds
      });
      const {
        ruleExecutionStatus,
        ruleMutedStatus,
        ruleEnabledStatus,
        ruleSnoozedStatus
      } = response;
      if (ruleExecutionStatus && ruleMutedStatus && ruleEnabledStatus && ruleSnoozedStatus) {
        const total = Object.values(ruleExecutionStatus).reduce((acc, value) => acc + value, 0);
        const {
          disabled
        } = ruleEnabledStatus;
        const {
          muted
        } = ruleMutedStatus;
        const {
          error
        } = ruleExecutionStatus;
        const {
          snoozed
        } = ruleSnoozedStatus;
        setRuleStats({
          ...ruleStats,
          total,
          disabled,
          muted,
          error,
          snoozed
        });
      }
      setRuleStatsLoading(false);
    } catch (_e) {
      toasts.addDanger({
        title: _i18n.i18n.translate('xpack.observability.alerts.ruleStats.loadError', {
          defaultMessage: 'Unable to load rule stats'
        })
      });
      setRuleStatsLoading(false);
    }
  }
  (0, _react.useEffect)(() => {
    loadRuleStats();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  const manageRulesHref = http.basePath.prepend('/app/observability/alerts/rules');
  return /*#__PURE__*/_react.default.createElement(_containers.Provider, {
    value: _containers.alertSearchBarStateContainer
  }, /*#__PURE__*/_react.default.createElement(ObservabilityPageTemplate, {
    "data-test-subj": "alertsPageWithData",
    pageHeader: {
      pageTitle: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _i18n.i18n.translate('xpack.observability.alertsTitle', {
        defaultMessage: 'Alerts'
      }), " "),
      rightSideItems: (0, _rule_stats.renderRuleStats)(ruleStats, manageRulesHref, ruleStatsLoading, locators.get(_common.rulesLocatorID))
    }
  }, /*#__PURE__*/_react.default.createElement(_header_menu.HeaderMenu, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_alertsUiShared.MaintenanceWindowCallout, {
    kibanaServices: kibanaServices,
    categories: [_coreApplicationCommon.DEFAULT_APP_CATEGORIES.observability.id]
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_alert_search_bar.ObservabilityAlertSearchBar, (0, _extends2.default)({}, alertSearchBarStateProps, {
    appName: ALERTS_SEARCH_BAR_ID,
    onEsQueryChange: setEsQuery,
    showFilterBar: true,
    services: {
      timeFilterService,
      AlertsSearchBar,
      useToasts: _use_toast.useToasts,
      uiSettings
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(AlertSummaryWidget, {
    featureIds: _constants.observabilityAlertFeatureIds,
    filter: esQuery,
    fullSize: true,
    timeRange: alertSummaryTimeRange,
    chartProps: chartProps
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, esQuery && /*#__PURE__*/_react.default.createElement(AlertsStateTable, {
    alertsTableConfigurationRegistry: alertsTableConfigurationRegistry,
    configurationId: _ruleDataUtils.AlertConsumers.OBSERVABILITY,
    id: ALERTS_TABLE_ID,
    featureIds: _constants.observabilityAlertFeatureIds,
    query: esQuery,
    showAlertStatusWithFlapping: true,
    pageSize: ALERTS_PER_PAGE,
    cellContext: {
      observabilityRuleTypeRegistry
    }
  })))));
}
function AlertsPage() {
  return /*#__PURE__*/_react.default.createElement(_containers.Provider, {
    value: _containers.alertSearchBarStateContainer
  }, /*#__PURE__*/_react.default.createElement(InternalAlertsPage, null));
}