"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.untrackedAlert = exports.tags = exports.mockAlertUuid = exports.alertWithTags = exports.alertWithNoData = exports.alertDetail = exports.alert = void 0;
var _ruleDataUtils = require("@kbn/rule-data-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const tags = exports.tags = ['tag1', 'tag2', 'tag3'];
const mockAlertUuid = exports.mockAlertUuid = '756240e5-92fb-452f-b08e-cd3e0dc51738';
const alert = exports.alert = {
  reason: '1957 log entries (more than 100.25) match the conditions.',
  fields: {
    [_ruleDataUtils.ALERT_STATUS]: 'active',
    [_ruleDataUtils.TIMESTAMP]: '2021-09-02T13:08:51.750Z',
    [_ruleDataUtils.ALERT_DURATION]: 882076000,
    [_ruleDataUtils.ALERT_REASON]: '1957 log entries (more than 100.25) match the conditions.',
    [_ruleDataUtils.ALERT_WORKFLOW_STATUS]: 'open',
    [_ruleDataUtils.ALERT_RULE_UUID]: 'db2ab7c0-0bec-11ec-9ae2-5b10ca924404',
    [_ruleDataUtils.ALERT_RULE_PRODUCER]: 'logs',
    [_ruleDataUtils.ALERT_RULE_CONSUMER]: 'logs',
    [_ruleDataUtils.ALERT_RULE_CATEGORY]: 'Log threshold',
    [_ruleDataUtils.ALERT_RULE_REVISION]: 0,
    [_ruleDataUtils.ALERT_START]: '2021-09-02T12:54:09.674Z',
    [_ruleDataUtils.ALERT_RULE_TYPE_ID]: 'logs.alert.document.count',
    [_ruleDataUtils.EVENT_ACTION]: 'active',
    [_ruleDataUtils.ALERT_EVALUATION_VALUE]: 1957,
    [_ruleDataUtils.ALERT_INSTANCE_ID]: '*',
    [_ruleDataUtils.ALERT_RULE_NAME]: 'Log threshold (from logs)',
    [_ruleDataUtils.ALERT_UUID]: mockAlertUuid,
    [_ruleDataUtils.SPACE_IDS]: ['default'],
    [_ruleDataUtils.VERSION]: '8.0.0',
    [_ruleDataUtils.EVENT_KIND]: 'signal',
    [_ruleDataUtils.ALERT_EVALUATION_THRESHOLD]: 100.25,
    [_ruleDataUtils.ALERT_RULE_TAGS]: []
  },
  active: true,
  start: 1630587249674,
  lastUpdated: 1630588131750
};
const alertDetail = exports.alertDetail = {
  formatted: alert,
  raw: Object.fromEntries(Object.entries(alert.fields).map(([k, v]) => [k, !Array.isArray(v) ? [v] : v]))
};
const alertWithTags = exports.alertWithTags = {
  ...alert,
  fields: {
    ...alert.fields,
    [_ruleDataUtils.ALERT_RULE_TAGS]: tags
  }
};
const untrackedAlert = exports.untrackedAlert = {
  ...alertWithTags,
  fields: {
    ...alertWithTags.fields,
    [_ruleDataUtils.ALERT_STATUS]: _ruleDataUtils.ALERT_STATUS_UNTRACKED
  }
};
const alertWithNoData = exports.alertWithNoData = null;