"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertSummary = AlertSummary;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function AlertSummary({
  alertSummaryFields
}) {
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "alert-summary-container"
  }, alertSummaryFields && alertSummaryFields.length > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xl"
  }, alertSummaryFields.map((field, idx) => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: idx,
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "subdued"
    }, field.label), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, field.value));
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  })));
}