"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleConditionChart = RuleConditionChart;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _useAsync = _interopRequireDefault(require("react-use/lib/useAsync"));
var _lensEmbeddableUtils = require("@kbn/lens-embeddable-utils");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../../common/constants");
var _types = require("../../../../../common/custom_threshold_rule/types");
var _kibana_react = require("../../../../utils/kibana_react");
var _painless_tinymath_parser = require("./painless_tinymath_parser");
var _helpers = require("./helpers");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const defaultQuery = {
  language: 'kuery',
  query: ''
};
function RuleConditionChart({
  metricExpression,
  searchConfiguration,
  dataView,
  groupBy,
  error,
  annotations,
  timeRange,
  chartOptions: {
    seriesType,
    interval
  } = {},
  additionalFilters = []
}) {
  const {
    services: {
      lens
    }
  } = (0, _kibana_react.useKibana)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    metrics,
    timeSize,
    timeUnit,
    threshold,
    comparator,
    equation
  } = metricExpression;
  const [attributes, setAttributes] = (0, _react.useState)();
  const [aggMap, setAggMap] = (0, _react.useState)();
  const [formula, setFormula] = (0, _react.useState)('');
  const [thresholdReferenceLine, setThresholdReferenceLine] = (0, _react.useState)();
  const [alertAnnotation, setAlertAnnotation] = (0, _react.useState)();
  const [chartLoading, setChartLoading] = (0, _react.useState)(false);
  const filters = [...(searchConfiguration.filter || []), ...additionalFilters];
  const formulaAsync = (0, _useAsync.default)(() => {
    return lens.stateHelperApi();
  }, [lens]);

  // Handle Lens error
  (0, _react.useEffect)(() => {
    // Lens does not expose or provide a way to check if there is an error in the chart, yet.
    // To work around this, we check if the element with class 'lnsEmbeddedError' is found in the DOM.
    setTimeout(function () {
      const errorDiv = document.querySelector('.lnsEmbeddedError');
      if (errorDiv) {
        const paragraphElements = errorDiv.querySelectorAll('p');
        if (!paragraphElements || paragraphElements.length < 2) return;
        paragraphElements[0].innerText = _i18n.i18n.translate('xpack.observability.customThreshold.rule..charts.error_equation.title', {
          defaultMessage: 'An error occurred while rendering the chart'
        });
        paragraphElements[1].innerText = _i18n.i18n.translate('xpack.observability.customThreshold.rule..charts.error_equation.description', {
          defaultMessage: 'Check the rule equation.'
        });
      }
    });
  }, [chartLoading, attributes]);

  // Build the threshold reference line
  (0, _react.useEffect)(() => {
    if (!threshold) return;
    const refLayers = [];
    if (comparator === _types.Comparator.OUTSIDE_RANGE || comparator === _types.Comparator.BETWEEN && threshold.length === 2) {
      const refLineStart = new _lensEmbeddableUtils.XYReferenceLinesLayer({
        data: [{
          value: (threshold[0] || 0).toString(),
          color: euiTheme.colors.danger,
          fill: comparator === _types.Comparator.OUTSIDE_RANGE ? 'below' : 'none'
        }]
      });
      const refLineEnd = new _lensEmbeddableUtils.XYReferenceLinesLayer({
        data: [{
          value: (threshold[1] || 0).toString(),
          color: euiTheme.colors.danger,
          fill: comparator === _types.Comparator.OUTSIDE_RANGE ? 'above' : 'none'
        }]
      });
      refLayers.push(refLineStart, refLineEnd);
    } else {
      let fill = 'above';
      if (comparator === _types.Comparator.LT || comparator === _types.Comparator.LT_OR_EQ) {
        fill = 'below';
      }
      const thresholdRefLine = new _lensEmbeddableUtils.XYReferenceLinesLayer({
        data: [{
          value: (threshold[0] || 0).toString(),
          color: euiTheme.colors.danger,
          fill
        }]
      });
      // A transparent line to add extra buffer at the top of threshold
      const bufferRefLine = new _lensEmbeddableUtils.XYReferenceLinesLayer({
        data: [{
          value: (0, _helpers.getBufferThreshold)(threshold[0]),
          color: 'transparent',
          fill
        }]
      });
      refLayers.push(thresholdRefLine, bufferRefLine);
    }
    setThresholdReferenceLine(refLayers);
  }, [threshold, comparator, euiTheme.colors.danger, metrics]);

  // Build alert annotation
  (0, _react.useEffect)(() => {
    if (!annotations) return;
    const alertAnnotationLayer = new _lensEmbeddableUtils.XYByValueAnnotationsLayer({
      annotations,
      ignoreGlobalFilters: true,
      dataView
    });
    setAlertAnnotation(alertAnnotationLayer);
  }, [euiTheme.colors.danger, dataView, annotations]);

  // Build the aggregation map from the metrics
  (0, _react.useEffect)(() => {
    if (!metrics || metrics.length === 0) {
      return;
    }
    const aggMapFromMetrics = metrics.reduce((acc, metric) => {
      const operationField = (0, _helpers.getLensOperationFromRuleMetric)(metric);
      return {
        ...acc,
        [metric.name]: operationField
      };
    }, {});
    setAggMap(aggMapFromMetrics);
  }, [metrics]);

  // Parse the equation
  (0, _react.useEffect)(() => {
    try {
      if (!aggMap) return;
      const parser = new _painless_tinymath_parser.PainlessTinyMathParser({
        aggMap,
        equation: equation || Object.keys(aggMap || {}).join(' + ')
      });
      setFormula(parser.parse());
    } catch (e) {
      // The error will appear on Lens chart.
      setAttributes(undefined);
      return;
    }
  }, [aggMap, equation]);
  (0, _react.useEffect)(() => {
    if (!formulaAsync.value || !dataView || !formula) {
      return;
    }
    const formatId = (0, _helpers.lensFieldFormatter)(metrics);
    const baseLayer = {
      type: 'formula',
      value: formula,
      label: 'Custom Threshold',
      groupBy,
      format: {
        id: formatId,
        params: {
          decimals: formatId === _helpers.LensFieldFormat.PERCENT ? 0 : 2,
          suffix: (0, _helpers.isRate)(metrics) && formatId === _helpers.LensFieldFormat.NUMBER ? _constants.EventsAsUnit : undefined
        }
      }
    };
    const xYDataLayerOptions = {
      buckets: {
        type: 'date_histogram',
        params: {
          interval: interval || `${timeSize}${timeUnit}`
        }
      },
      seriesType: seriesType ? seriesType : 'bar'
    };
    if (groupBy && groupBy !== null && groupBy !== void 0 && groupBy.length) {
      xYDataLayerOptions.breakdown = {
        type: 'top_values',
        field: groupBy[0],
        params: {
          size: 3,
          secondaryFields: groupBy.slice(1),
          accuracyMode: false
        }
      };
    }
    const xyDataLayer = new _lensEmbeddableUtils.XYDataLayer({
      data: [baseLayer].map(layer => ({
        type: layer.type,
        value: layer.value,
        label: layer.label,
        format: layer.format,
        // We always scale the chart with seconds with RATE Agg.
        timeScale: (0, _helpers.isRate)(metrics) ? 's' : undefined
      })),
      options: xYDataLayerOptions
    });
    const layers = [xyDataLayer];
    if (thresholdReferenceLine) {
      layers.push(...thresholdReferenceLine);
    }
    if (alertAnnotation) {
      layers.push(alertAnnotation);
    }
    const attributesLens = new _lensEmbeddableUtils.LensAttributesBuilder({
      visualization: new _lensEmbeddableUtils.XYChart({
        visualOptions: {
          valueLabels: 'hide',
          axisTitlesVisibilitySettings: {
            x: true,
            yLeft: false,
            yRight: true
          }
        },
        layers,
        formulaAPI: formulaAsync.value.formula,
        dataView
      })
    }).build();
    const lensBuilderAtt = {
      ...attributesLens,
      type: 'lens'
    };
    setAttributes(lensBuilderAtt);
  }, [comparator, dataView, equation, searchConfiguration, formula, formulaAsync.value, groupBy, interval, metrics, threshold, thresholdReferenceLine, alertAnnotation, timeSize, timeUnit, seriesType]);
  if (!dataView || !attributes || error !== null && error !== void 0 && error.equation || Object.keys((error === null || error === void 0 ? void 0 : error.metrics) || {}).length !== 0 || !timeSize || !timeRange) {
    return /*#__PURE__*/_react.default.createElement("div", {
      style: {
        maxHeight: 180,
        minHeight: 180
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      iconType: "visArea",
      titleSize: "xxs",
      "data-test-subj": "thresholdRuleNoChartData",
      body: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.observability.customThreshold.rule..charts.noData.title",
        defaultMessage: "No chart data available, check the rule {errorSourceField}",
        values: {
          errorSourceField: Object.keys((error === null || error === void 0 ? void 0 : error.metrics) || {}).length !== 0 ? 'aggregation fields' : error !== null && error !== void 0 && error.equation ? 'equation' : 'conditions'
        }
      })
    }));
  }
  return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(lens.EmbeddableComponent, {
    onLoad: setChartLoading,
    id: "customThresholdPreviewChart",
    style: {
      height: 180
    },
    timeRange: timeRange,
    attributes: attributes,
    disableTriggers: true,
    query: searchConfiguration.query || defaultQuery,
    filters: filters
  }));
}