"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = AlertDetailsAppSection;
var _chromaJs = _interopRequireDefault(require("chroma-js"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _observabilityGetPaddedAlertTimeRangeUtil = require("@kbn/observability-get-padded-alert-time-range-util");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _moment = _interopRequireDefault(require("moment"));
var _deeplinksObservability = require("@kbn/deeplinks-observability");
var _alert_history = require("./alert_history");
var _use_license = require("../../../../hooks/use_license");
var _kibana_react = require("../../../../utils/kibana_react");
var _get_group = require("../../../../../common/custom_threshold_rule/helpers/get_group");
var _metric_value_formatter = require("../../../../../common/custom_threshold_rule/metric_value_formatter");
var _criterion_preview_chart = require("../criterion_preview_chart/criterion_preview_chart");
var _custom_threshold = require("../custom_threshold");
var _log_rate_analysis = require("./log_rate_analysis");
var _groups = require("./groups");
var _tags = require("./tags");
var _rule_condition_chart = require("../rule_condition_chart/rule_condition_chart");
var _get_view_in_app_url = require("../../../../../common/custom_threshold_rule/get_view_in_app_url");
var _generate_chart_title_and_tooltip = require("./helpers/generate_chart_title_and_tooltip");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// eslint-disable-next-line import/no-default-export
function AlertDetailsAppSection({
  alert,
  rule,
  ruleLink,
  setAlertSummaryFields
}) {
  const services = (0, _kibana_react.useKibana)().services;
  const {
    charts,
    data,
    share: {
      url: {
        locators
      }
    }
  } = services;
  const {
    hasAtLeast
  } = (0, _use_license.useLicense)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const hasLogRateAnalysisLicense = hasAtLeast('platinum');
  const [dataView, setDataView] = (0, _react.useState)();
  const [, setDataViewError] = (0, _react.useState)();
  const [viewInAppUrl, setViewInAppUrl] = (0, _react.useState)();
  const [timeRange, setTimeRange] = (0, _react.useState)({
    from: 'now-15m',
    to: 'now'
  });
  const ruleParams = rule.params;
  const chartProps = {
    baseTheme: charts.theme.useChartsBaseTheme()
  };
  const alertStart = alert.fields[_ruleDataUtils.ALERT_START];
  const alertEnd = alert.fields[_ruleDataUtils.ALERT_END];
  const groups = alert.fields[_ruleDataUtils.ALERT_GROUP];
  const tags = alert.fields[_ruleDataUtils.TAGS];
  const chartTitleAndTooltip = [];
  ruleParams.criteria.forEach(criterion => {
    chartTitleAndTooltip.push((0, _generate_chart_title_and_tooltip.generateChartTitleAndTooltip)(criterion));
  });
  const alertStartAnnotation = {
    label: 'Alert',
    type: 'manual',
    key: {
      type: 'point_in_time',
      timestamp: alertStart
    },
    color: euiTheme.colors.danger,
    icon: 'alert',
    id: 'custom_threshold_alert_start_annotation'
  };
  const alertRangeAnnotation = {
    label: `${alertEnd ? 'Alert duration' : 'Active alert'}`,
    type: 'manual',
    key: {
      type: 'range',
      timestamp: alertStart,
      endTimestamp: alertEnd !== null && alertEnd !== void 0 ? alertEnd : (0, _moment.default)().toISOString()
    },
    color: (0, _chromaJs.default)((0, _eui.transparentize)('#F04E981A', 0.2)).hex().toUpperCase(),
    id: `custom_threshold_${alertEnd ? 'recovered' : 'active'}_alert_range_annotation`
  };
  const annotations = [];
  annotations.push(alertStartAnnotation, alertRangeAnnotation);
  (0, _react.useEffect)(() => {
    setTimeRange((0, _observabilityGetPaddedAlertTimeRangeUtil.getPaddedAlertTimeRange)(alertStart, alertEnd));
  }, [alertStart, alertEnd]);
  (0, _react.useEffect)(() => {
    var _ruleParams$criteria$;
    const appUrl = (0, _get_view_in_app_url.getViewInAppUrl)({
      dataViewId: dataView === null || dataView === void 0 ? void 0 : dataView.id,
      groups,
      logsExplorerLocator: locators.get(_deeplinksObservability.LOGS_EXPLORER_LOCATOR_ID),
      metrics: (_ruleParams$criteria$ = ruleParams.criteria[0]) === null || _ruleParams$criteria$ === void 0 ? void 0 : _ruleParams$criteria$.metrics,
      searchConfiguration: ruleParams.searchConfiguration,
      startedAt: alertStart,
      endedAt: alertEnd
    });
    setViewInAppUrl(appUrl);
  }, [dataView, alertStart, alertEnd, groups, ruleParams, locators]);
  (0, _react.useEffect)(() => {
    const alertSummaryFields = [];
    if (groups) {
      alertSummaryFields.push({
        label: _i18n.i18n.translate('xpack.observability.customThreshold.rule.alertDetailsAppSection.summaryField.source', {
          defaultMessage: 'Source'
        }),
        value: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_groups.Groups, {
          groups: groups,
          timeRange: alertEnd ? timeRange : {
            ...timeRange,
            to: 'now'
          }
        }), /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          "data-test-subj": "o11yCustomThresholdAlertDetailsViewRelatedLogs",
          href: viewInAppUrl
        }, _i18n.i18n.translate('xpack.observability.alertDetailsAppSection.a.viewRelatedLogsLabel', {
          defaultMessage: 'View related logs'
        }))))
      });
    }
    if (tags && tags.length > 0) {
      alertSummaryFields.push({
        label: _i18n.i18n.translate('xpack.observability.customThreshold.rule.alertDetailsAppSection.summaryField.tags', {
          defaultMessage: 'Tags'
        }),
        value: /*#__PURE__*/_react.default.createElement(_tags.Tags, {
          tags: tags
        })
      });
    }
    alertSummaryFields.push({
      label: _i18n.i18n.translate('xpack.observability.customThreshold.rule.alertDetailsAppSection.summaryField.rule', {
        defaultMessage: 'Rule'
      }),
      value: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "thresholdRuleAlertDetailsAppSectionRuleLink",
        href: ruleLink
      }, rule.name)
    });
    setAlertSummaryFields(alertSummaryFields);
  }, [groups, tags, rule, ruleLink, setAlertSummaryFields, timeRange, alertEnd, viewInAppUrl]);
  (0, _react.useEffect)(() => {
    const initDataView = async () => {
      const ruleSearchConfiguration = ruleParams.searchConfiguration;
      try {
        const createdSearchSource = await data.search.searchSource.create(ruleSearchConfiguration);
        setDataView(createdSearchSource.getField('index'));
      } catch (error) {
        setDataViewError(error);
      }
    };
    initDataView();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [data.search.searchSource]);
  if (!ruleParams.criteria) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    "data-test-subj": "thresholdAlertOverviewSection"
  }, ruleParams.criteria.map((criterion, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: `criterion-${index}`
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    hasShadow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: chartTitleAndTooltip[index].tooltip
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h4", {
    "data-test-subj": `chartTitle-${index}`
  }, chartTitleAndTooltip[index].title))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.observability.customThreshold.rule.alertDetailsAppSection.criterion.subtitle",
    defaultMessage: "Last {lookback} {timeLabel}",
    values: {
      lookback: criterion.timeSize,
      timeLabel: _criterion_preview_chart.TIME_LABELS[criterion.timeUnit]
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: {
      minHeight: 150,
      minWidth: 160
    },
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_custom_threshold.Threshold, {
    chartProps: chartProps,
    id: `threshold-${index}`,
    threshold: criterion.threshold,
    value: alert.fields[_ruleDataUtils.ALERT_EVALUATION_VALUES][index],
    valueFormatter: d => (0, _metric_value_formatter.metricValueFormatter)(d, criterion.metrics[0] ? criterion.metrics[0].name : undefined),
    title: _i18n.i18n.translate('xpack.observability.customThreshold.rule.alertDetailsAppSection.thresholdTitle', {
      defaultMessage: 'Threshold breached'
    }),
    comparator: criterion.comparator
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 5
  }, /*#__PURE__*/_react.default.createElement(_rule_condition_chart.RuleConditionChart, {
    additionalFilters: (0, _get_group.getGroupFilters)(groups),
    annotations: annotations,
    chartOptions: {
      // For alert details page, the series type needs to be changed to 'bar_stacked'
      // due to https://github.com/elastic/elastic-charts/issues/2323
      seriesType: 'bar_stacked'
    },
    dataView: dataView,
    groupBy: ruleParams.groupBy,
    metricExpression: criterion,
    searchConfiguration: ruleParams.searchConfiguration,
    timeRange: timeRange
  })))))), hasLogRateAnalysisLicense && /*#__PURE__*/_react.default.createElement(_log_rate_analysis.LogRateAnalysis, {
    alert: alert,
    dataView: dataView,
    rule: rule,
    services: services
  }), /*#__PURE__*/_react.default.createElement(_alert_history.AlertHistoryChart, {
    alert: alert,
    dataView: dataView,
    rule: rule
  }));
}
module.exports = exports.default;