"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getColumns = void 0;
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * We need to produce types and code transpilation at different folders during the build of the package.
 * We have types and code at different imports because we don't want to import the whole package in the resulting webpack bundle for the plugin.
 * This way plugins can do targeted imports to reduce the final code bundle
 */

/**
 * columns implements a subset of `EuiDataGrid`'s `EuiDataGridColumn` interface,
 * plus additional TGrid column properties
 */
const getColumns = ({
  showRuleName
} = {
  showRuleName: false
}) => {
  const ruleNameColumn = showRuleName ? [{
    columnHeaderType: 'not-filtered',
    displayAsText: _i18n.i18n.translate('xpack.observability.alertsTGrid.ruleNameColumnDescription', {
      defaultMessage: 'Rule name'
    }),
    id: _ruleDataUtils.ALERT_RULE_NAME,
    initialWidth: 150
  }] : [];
  return [{
    columnHeaderType: 'not-filtered',
    displayAsText: _i18n.i18n.translate('xpack.observability.alertsTGrid.statusColumnDescription', {
      defaultMessage: 'Alert Status'
    }),
    id: _ruleDataUtils.ALERT_STATUS,
    initialWidth: 120
  }, {
    columnHeaderType: 'not-filtered',
    displayAsText: _i18n.i18n.translate('xpack.observability.alertsTGrid.triggeredColumnDescription', {
      defaultMessage: 'Triggered'
    }),
    id: _ruleDataUtils.ALERT_START,
    initialWidth: 190,
    schema: 'datetime'
  }, {
    columnHeaderType: 'not-filtered',
    displayAsText: _i18n.i18n.translate('xpack.observability.alertsTGrid.durationColumnDescription', {
      defaultMessage: 'Duration'
    }),
    id: _ruleDataUtils.ALERT_DURATION,
    initialWidth: 70
  }, ...ruleNameColumn, {
    columnHeaderType: 'not-filtered',
    displayAsText: _i18n.i18n.translate('xpack.observability.alertsTGrid.sourceColumnDescription', {
      defaultMessage: 'Group'
    }),
    id: _ruleDataUtils.ALERT_INSTANCE_ID,
    initialWidth: 100
  }, {
    columnHeaderType: 'not-filtered',
    displayAsText: _i18n.i18n.translate('xpack.observability.alertsTGrid.observedValueColumnDescription', {
      defaultMessage: 'Observed value'
    }),
    id: _ruleDataUtils.ALERT_EVALUATION_VALUE,
    initialWidth: 100
  }, {
    columnHeaderType: 'not-filtered',
    displayAsText: _i18n.i18n.translate('xpack.observability.alertsTGrid.thresholdColumnDescription', {
      defaultMessage: 'Threshold'
    }),
    id: _ruleDataUtils.ALERT_EVALUATION_THRESHOLD,
    initialWidth: 100
  }, {
    columnHeaderType: 'not-filtered',
    displayAsText: _i18n.i18n.translate('xpack.observability.alertsTGrid.tagsColumnDescription', {
      defaultMessage: 'Tags'
    }),
    id: _ruleDataUtils.TAGS,
    initialWidth: 150
  }, {
    columnHeaderType: 'not-filtered',
    displayAsText: _i18n.i18n.translate('xpack.observability.alertsTGrid.reasonColumnDescription', {
      defaultMessage: 'Reason'
    }),
    id: _ruleDataUtils.ALERT_REASON,
    linkField: '*'
  }];
};
exports.getColumns = getColumns;