"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertsFlyoutBody = AlertsFlyoutBody;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _alertsUiShared = require("@kbn/alerts-ui-shared");
var _alert_overview = require("../alert_overview/alert_overview");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function AlertsFlyoutBody({
  alert,
  rawAlert,
  id: pageId
}) {
  const overviewTab = (0, _react.useMemo)(() => {
    return {
      id: 'overview',
      'data-test-subj': 'overviewTab',
      name: _i18n.i18n.translate('xpack.observability.alertFlyout.overview', {
        defaultMessage: 'Overview'
      }),
      content: /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
        hasShadow: false,
        "data-test-subj": "overviewTabPanel"
      }, /*#__PURE__*/_react.default.createElement(_alert_overview.AlertOverview, {
        alert: alert,
        pageId: pageId
      }))
    };
  }, [alert, pageId]);
  const metadataTab = (0, _react.useMemo)(() => ({
    id: 'metadata',
    'data-test-subj': 'metadataTab',
    name: _i18n.i18n.translate('xpack.observability.alertsFlyout.metadata', {
      defaultMessage: 'Metadata'
    }),
    content: /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      hasShadow: false,
      "data-test-subj": "metadataTabPanel"
    }, /*#__PURE__*/_react.default.createElement(_alertsUiShared.AlertFieldsTable, {
      alert: rawAlert
    }))
  }), [rawAlert]);
  const tabs = (0, _react.useMemo)(() => [overviewTab, metadataTab], [overviewTab, metadataTab]);
  const [selectedTabId, setSelectedTabId] = (0, _react.useState)('overview');
  const handleTabClick = (0, _react.useCallback)(tab => setSelectedTabId(tab.id), []);
  const selectedTab = (0, _react.useMemo)(() => {
    var _tabs$find;
    return (_tabs$find = tabs.find(tab => tab.id === selectedTabId)) !== null && _tabs$find !== void 0 ? _tabs$find : tabs[0];
  }, [tabs, selectedTabId]);
  return /*#__PURE__*/_react.default.createElement(_alertsUiShared.ScrollableFlyoutTabbedContent, {
    tabs: tabs,
    selectedTab: selectedTab,
    onTabClick: handleTabClick,
    expand: true,
    "data-test-subj": "defaultAlertFlyoutTabs"
  });
}