"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.routes = exports.baseRoutes = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _custom_logs = require("../components/app/custom_logs");
var _system_logs = require("../components/app/system_logs");
var _home = require("../components/app/home");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const baseRoutes = exports.baseRoutes = {
  '/': {
    handler: () => /*#__PURE__*/_react.default.createElement(_home.Home, null),
    params: {},
    exact: true
  },
  '/overview': {
    handler: () => /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
      to: "/"
    }),
    params: {},
    exact: true
  }
};
const routes = exports.routes = {
  ...baseRoutes,
  ..._custom_logs.customLogsRoutes,
  ..._system_logs.systemLogsRoutes
};