"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFlowProgressTelemetry = useFlowProgressTelemetry;
var _react = require("react");
var _telemetry_events = require("../../common/telemetry_events");
var _use_experimental_onboarding_flag = require("./use_experimental_onboarding_flag");
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TRACKED_STEPS = ['ea-download', 'ea-status', 'logs-ingest'];
const TRACKED_STATUSES = ['danger', 'warning', 'complete'];
function useFlowProgressTelemetry(progress, flowId) {
  const {
    services: {
      analytics
    }
  } = (0, _use_kibana.useKibana)();
  const experimentalOnboardingFlowEnabled = (0, _use_experimental_onboarding_flag.useExperimentalOnboardingFlag)();
  const [previousReportedSteps] = (0, _react.useState)(new Map());
  (0, _react.useEffect)(() => {
    if (!progress) {
      return;
    }
    TRACKED_STEPS.forEach(stepId => {
      const step = progress[stepId];
      if (!step || !TRACKED_STATUSES.includes(step.status) || previousReportedSteps.get(stepId) === step.status) {
        return;
      }
      analytics.reportEvent(_telemetry_events.OBSERVABILITY_ONBOARDING_TELEMETRY_EVENT.eventType, {
        uses_legacy_onboarding_page: !experimentalOnboardingFlowEnabled,
        flow: flowId,
        step: stepId,
        step_status: step.status,
        step_message: step.message
      });
      previousReportedSteps.set(stepId, step.status);
    });
  }, [analytics, experimentalOnboardingFlowEnabled, flowId, progress, previousReportedSteps]);
}