"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfigureLogs = ConfigureLogs;
exports.ConfigureLogsContent = ConfigureLogsContent;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _customIntegrations = require("@kbn/custom-integrations");
var _public = require("@kbn/kibana-react-plugin/public");
var _2 = require(".");
var _optional_form_row = require("../../shared/optional_form_row");
var _step_panel = require("../../shared/step_panel");
var _back_button = require("../../shared/back_button");
var _get_filename = require("./get_filename");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const customIntegrationsTestSubjects = {
  create: {
    integrationName: 'obltOnboardingCustomLogsIntegrationsName',
    datasetName: 'obltOnboardingCustomLogsDatasetName',
    errorCallout: {
      callout: 'obltOnboardingCustomIntegrationErrorCallout'
    }
  },
  button: 'obltOnboardingCustomLogsContinue'
};
function ConfigureLogs() {
  const {
    services: {
      http
    }
  } = (0, _public.useKibana)();
  const {
    goToStep,
    setState,
    getState
  } = (0, _2.useWizard)();
  const {
    integrationName,
    datasetName,
    lastCreatedIntegrationOptions
  } = getState();
  const onIntegrationCreation = integrationOptions => {
    const {
      integrationName: createdIntegrationName,
      datasets: createdDatasets
    } = integrationOptions;
    setState(state => ({
      ...state,
      integrationName: createdIntegrationName,
      datasetName: createdDatasets[0].name,
      lastCreatedIntegrationOptions: integrationOptions
    }));
    goToStep('installElasticAgent');
  };
  return /*#__PURE__*/_react.default.createElement(_customIntegrations.CustomIntegrationsProvider, {
    services: {
      http
    },
    onIntegrationCreation: onIntegrationCreation,
    initialState: {
      mode: 'create',
      context: {
        options: {
          deletePrevious: true,
          resetOnCreation: false,
          errorOnFailedCleanup: false
        },
        ...(integrationName !== undefined && datasetName !== undefined ? {
          fields: {
            integrationName,
            datasets: [{
              name: datasetName,
              type: 'logs'
            }]
          }
        } : {}),
        previouslyCreatedIntegration: lastCreatedIntegrationOptions
      }
    }
  }, /*#__PURE__*/_react.default.createElement(ConfigureLogsContent, null));
}
function ConfigureLogsContent() {
  const {
    dispatchableEvents: {
      updateCreateFields
    }
  } = (0, _customIntegrations.useConsumerCustomIntegrations)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const xsFontSize = (0, _eui.useEuiFontSize)('xs').fontSize;
  const {
    goBack,
    getState,
    setState
  } = (0, _2.useWizard)();
  const wizardState = getState();
  const [serviceName, setServiceName] = (0, _react.useState)(wizardState.serviceName);
  const [logFilePaths, setLogFilePaths] = (0, _react.useState)(wizardState.logFilePaths);
  const [namespace, setNamespace] = (0, _react.useState)(wizardState.namespace);
  const [customConfigurations, setCustomConfigurations] = (0, _react.useState)(wizardState.customConfigurations);
  const logFilePathNotConfigured = logFilePaths.every(filepath => !filepath);
  const onContinue = (0, _react.useCallback)(() => {
    setState(state => ({
      ...state,
      serviceName,
      logFilePaths: logFilePaths.filter(filepath => !!filepath),
      namespace,
      customConfigurations
    }));
  }, [customConfigurations, logFilePaths, namespace, serviceName, setState]);
  function addLogFilePath() {
    setLogFilePaths(prev => [...prev, '']);
  }
  function removeLogFilePath(index) {
    setLogFilePaths(prev => prev.filter((_, i) => i !== index));
  }
  function onLogFilePathChanges(index, event) {
    var _event$currentTarget;
    const filepath = (_event$currentTarget = event.currentTarget) === null || _event$currentTarget === void 0 ? void 0 : _event$currentTarget.value;
    setLogFilePaths(prev => prev.map((path, i) => i === index ? filepath : path));
    if (index === 0) {
      if (updateCreateFields) {
        updateCreateFields({
          integrationName: (0, _get_filename.getFilename)(filepath).toLowerCase(),
          datasets: [{
            name: (0, _get_filename.getFilename)(filepath).toLowerCase(),
            type: 'logs'
          }]
        });
      }
    }
  }
  return /*#__PURE__*/_react.default.createElement(_step_panel.StepPanel, {
    panelFooter: /*#__PURE__*/_react.default.createElement(_step_panel.StepPanelFooter, {
      items: [/*#__PURE__*/_react.default.createElement(_back_button.BackButton, {
        onBack: goBack
      }), /*#__PURE__*/_react.default.createElement(_customIntegrations.ConnectedCustomIntegrationsButton, {
        isDisabled: logFilePathNotConfigured || !namespace,
        onClick: onContinue,
        testSubj: customIntegrationsTestSubjects.button
      })]
    })
  }, /*#__PURE__*/_react.default.createElement(_step_panel.StepPanelContent, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.observability_onboarding.configureLogs.description', {
    defaultMessage: 'Configure inputs'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.observability_onboarding.configureLogs.logFile.path', {
      defaultMessage: 'Log file path'
    }),
    helpText: _i18n.i18n.translate('xpack.observability_onboarding.configureLogs.logFile.helper', {
      defaultMessage: 'You can use a log file path or a log pattern.'
    })
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, logFilePaths.map((filepath, index) => /*#__PURE__*/_react.default.createElement("div", {
    key: index,
    "data-test-subj": `obltOnboardingLogFilePath-${index}`
  }, index > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    "data-test-subj": "observabilityOnboardingConfigureLogsFieldText",
    placeholder: _i18n.i18n.translate('xpack.observability_onboarding.configureLogs.logFile.placeholder', {
      defaultMessage: 'Example: /var/log/application.*'
    }),
    value: filepath,
    onChange: ev => onLogFilePathChanges(index, ev)
  })), index > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "trash",
    "aria-label": _i18n.i18n.translate('xpack.observability_onboarding.configureLogsContent.euiButtonIcon.deleteLabel', {
      defaultMessage: 'Delete'
    }),
    onClick: () => removeLogFilePath(index),
    "data-test-subj": `obltOnboardingLogFilePathDelete-${index}`
  }))))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "flexStart",
    direction: "column",
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "plusInCircle",
    onClick: addLogFilePath,
    "data-test-subj": "obltOnboardingCustomLogsAddFilePath"
  }, _i18n.i18n.translate('xpack.observability_onboarding.configureLogs.logFile.addRow', {
    defaultMessage: 'Add row'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_optional_form_row.OptionalFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "xs",
      responsive: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, _i18n.i18n.translate('xpack.observability_onboarding.configureLogs.serviceName', {
      defaultMessage: 'Service name'
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: _i18n.i18n.translate('xpack.observability_onboarding.configureLogs.serviceName.tooltip', {
        defaultMessage: 'Provide a service name to allow for distributed services running on multiple hosts to correlate the related instances.'
      }),
      position: "right"
    }))),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.observability_onboarding.configureLogs.serviceName.helper",
      defaultMessage: "Name the service your data is collected from."
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    placeholder: _i18n.i18n.translate('xpack.observability_onboarding.configureLogs.serviceName.placeholder', {
      defaultMessage: 'Give your service a name'
    }),
    value: serviceName,
    onChange: event => setServiceName(event.target.value),
    "data-test-subj": "obltOnboardingCustomLogsServiceName"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "flexStart",
    direction: "column",
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: {
      width: '100%'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: "advancedSettingsAccordion",
    css: {
      '.euiAccordion__buttonContent': {
        color: euiTheme.colors.primaryText,
        fontSize: xsFontSize
      },
      '.euiAccordion__arrow svg': {
        stroke: euiTheme.colors.primary,
        width: euiTheme.size.m,
        height: euiTheme.size.m
      }
    },
    buttonContent: _i18n.i18n.translate('xpack.observability_onboarding.configureLogs.advancedSettings', {
      defaultMessage: 'Advanced settings'
    }),
    "data-test-subj": "obltOnboardingCustomLogsAdvancedSettings"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "xs",
      responsive: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, _i18n.i18n.translate('xpack.observability_onboarding.configureLogs.namespace', {
      defaultMessage: 'Namespace'
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: _i18n.i18n.translate('xpack.observability_onboarding.configureLogs.namespace.tooltip', {
        defaultMessage: 'Provide a namespace to customize the grouping of your logs. Defaults to the default namespace.'
      }),
      position: "right"
    }))),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.observability_onboarding.configureLogs.namespace.helper",
      defaultMessage: "This setting changes the name of the integration's data stream. {learnMoreLink}",
      values: {
        learnMoreLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          "data-test-subj": "observabilityOnboardingConfigureLogsLearnMoreLink",
          external: true,
          target: "_blank",
          href: 'https://www.elastic.co/guide/en/fleet/current/data-streams.html#data-streams-naming-scheme'
        }, _i18n.i18n.translate('xpack.observability_onboarding.configureLogs.learnMore', {
          defaultMessage: 'Learn more'
        }))
      }
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    placeholder: _i18n.i18n.translate('xpack.observability_onboarding.configureLogs.namespace.placeholder', {
      defaultMessage: 'Namespace'
    }),
    value: namespace,
    onChange: event => setNamespace(event.target.value),
    "data-test-subj": "obltOnboardingCustomLogsNamespace"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_optional_form_row.OptionalFormRow, {
    label: _i18n.i18n.translate('xpack.observability_onboarding.configureLogs.customConfig', {
      defaultMessage: 'Custom configurations'
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.observability_onboarding.configureLogs.customConfig.helper",
      defaultMessage: "Add YAML configuration options to your agent configuration. Be careful using this feature as it can break your configuration file. {learnMoreLink}",
      values: {
        learnMoreLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          "data-test-subj": "observabilityOnboardingConfigureLogsLearnMoreLink",
          external: true,
          target: "_blank",
          href: 'https://www.elastic.co/guide/en/beats/filebeat/current/multiline-examples.html'
        }, _i18n.i18n.translate('xpack.observability_onboarding.configureLogs.learnMore', {
          defaultMessage: 'Learn more'
        }))
      }
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, {
    value: customConfigurations,
    onChange: event => setCustomConfigurations(event.target.value),
    "data-test-subj": "obltOnboardingCustomLogsCustomConfig"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_customIntegrations.ConnectedCustomIntegrationsForm, {
    testSubjects: customIntegrationsTestSubjects
  })));
}