"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useWizard = exports.customLogsRoutes = exports.Provider = exports.CustomLogsPanel = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _create_wizard_context = require("../../../context/create_wizard_context");
var _configure_logs = require("./configure_logs");
var _inspect = require("./inspect");
var _install_elastic_agent = require("./install_elastic_agent");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initialState = {
  integrationName: undefined,
  datasetName: undefined,
  serviceName: '',
  logFilePaths: [''],
  namespace: 'default',
  customConfigurations: '',
  elasticAgentPlatform: 'linux-tar',
  autoDownloadConfig: false,
  apiKeyEncoded: '',
  onboardingId: ''
};
const steps = {
  configureLogs: {
    component: _configure_logs.ConfigureLogs
  },
  installElasticAgent: {
    component: _install_elastic_agent.InstallElasticAgent,
    title: _i18n.i18n.translate('xpack.observability_onboarding.customLogs.installShipper.title', {
      defaultMessage: 'Install shipper to collect logs'
    })
  },
  inspect: {
    component: _inspect.Inspect
  }
};
const {
  Provider,
  useWizard,
  routes: customLogsRoutes
} = (0, _create_wizard_context.createWizardContext)({
  initialState,
  initialStep: 'configureLogs',
  steps,
  basePath: '/customLogs'
});
exports.customLogsRoutes = customLogsRoutes;
exports.useWizard = useWizard;
exports.Provider = Provider;
const CustomLogsPanel = () => {
  return /*#__PURE__*/_react.default.createElement(Provider, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true
  }, Object.keys(customLogsRoutes).map(key => {
    const path = key;
    const {
      handler,
      exact
    } = customLogsRoutes[path];
    return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
      key: path,
      path: path,
      exact: exact,
      component: handler
    });
  })));
};
exports.CustomLogsPanel = CustomLogsPanel;