"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCustomCardsForCategory = useCustomCardsForCategory;
var _public = require("@kbn/kibana-react-plugin/public");
var _reactRouterDom = require("react-router-dom");
var _reactRouterDomV5Compat = require("react-router-dom-v5-compat");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function toFeaturedCard(name) {
  return {
    type: 'featured',
    name
  };
}
function useCustomCardsForCategory(createCollectionCardHandler, category) {
  var _useKibana, _useKibana$services$a, _getUrlForApp, _getUrlForApp2;
  const history = (0, _reactRouterDom.useHistory)();
  const location = (0, _reactRouterDomV5Compat.useLocation)();
  const getUrlForApp = (_useKibana = (0, _public.useKibana)()) === null || _useKibana === void 0 ? void 0 : (_useKibana$services$a = _useKibana.services.application) === null || _useKibana$services$a === void 0 ? void 0 : _useKibana$services$a.getUrlForApp;
  const {
    href: systemLogsUrl
  } = (0, _public.reactRouterNavigate)(history, `/systemLogs/${location.search}`);
  const {
    href: customLogsUrl
  } = (0, _public.reactRouterNavigate)(history, `/customLogs/${location.search}`);
  switch (category) {
    case 'apm':
      return [{
        id: 'apm-generated',
        type: 'generated',
        title: 'Elastic APM',
        description: 'Collect distributed traces from your applications with Elastic APM',
        name: 'apm',
        categories: ['observability'],
        icons: [{
          type: 'eui',
          src: 'apmApp'
        }],
        url: (_getUrlForApp = getUrlForApp === null || getUrlForApp === void 0 ? void 0 : getUrlForApp('apm')) !== null && _getUrlForApp !== void 0 ? _getUrlForApp : '',
        version: '',
        integration: ''
      }, {
        id: 'synthetics-generated',
        type: 'generated',
        title: 'Synthetic monitor',
        description: 'Monitor endpoints, pages, and user journeys',
        name: 'synthetics',
        categories: ['observability'],
        icons: [{
          type: 'eui',
          src: 'logoUptime'
        }],
        url: (_getUrlForApp2 = getUrlForApp === null || getUrlForApp === void 0 ? void 0 : getUrlForApp('synthetics')) !== null && _getUrlForApp2 !== void 0 ? _getUrlForApp2 : '',
        version: '',
        integration: ''
      }];
    case 'infra':
      return [toFeaturedCard('kubernetes'), toFeaturedCard('prometheus'), toFeaturedCard('docker'), {
        id: 'azure-generated',
        type: 'generated',
        title: 'Azure',
        description: 'Collect logs and metrics from Microsoft Azure',
        name: 'azure',
        categories: ['observability'],
        icons: [],
        url: 'https://azure.com',
        version: '',
        integration: '',
        isCollectionCard: true,
        onCardClick: createCollectionCardHandler('azure')
      }, {
        id: 'aws-generated',
        type: 'generated',
        title: 'AWS',
        description: 'Collect logs and metrics from Amazon Web Services (AWS)',
        name: 'aws',
        categories: ['observability'],
        icons: [],
        url: 'https://aws.com',
        version: '',
        integration: '',
        isCollectionCard: true,
        onCardClick: createCollectionCardHandler('aws')
      }, {
        id: 'gcp-generated',
        type: 'generated',
        title: 'Google Cloud Platform',
        description: 'Collect logs and metrics from Google Cloud Platform',
        name: 'gcp',
        categories: ['observability'],
        icons: [],
        url: '',
        version: '',
        integration: '',
        isCollectionCard: true,
        onCardClick: createCollectionCardHandler('gcp')
      }];
    case 'logs':
      return [{
        id: 'system-logs',
        type: 'generated',
        title: 'Stream host system logs',
        description: 'The quickest path to onboard log data from your own machine or server',
        name: 'system-logs-generated',
        categories: ['observability'],
        icons: [{
          type: 'svg',
          src: '/XXXXXXXXXXXX/plugins/home/assets/logos/system.svg'
        }],
        url: systemLogsUrl,
        version: '',
        integration: ''
      }, {
        id: 'logs-logs',
        type: 'generated',
        title: 'Stream log files',
        description: 'Stream any logs into Elastic in a simple way and explore their data',
        name: 'logs-logs-generated',
        categories: ['observability'],
        icons: [{
          type: 'eui',
          src: 'filebeatApp'
        }],
        url: customLogsUrl,
        version: '',
        integration: ''
      }, toFeaturedCard('nginx'), {
        id: 'azure-logs-generated',
        type: 'generated',
        title: 'Azure',
        description: 'Collect logs from Microsoft Azure',
        name: 'azure',
        categories: ['observability'],
        icons: [],
        url: 'https://azure.com',
        version: '',
        integration: '',
        isCollectionCard: true,
        onCardClick: createCollectionCardHandler('azure')
      }, {
        id: 'aws-logs-generated',
        type: 'generated',
        title: 'AWS',
        description: 'Collect logs from Amazon Web Services (AWS)',
        name: 'aws',
        categories: ['observability'],
        icons: [],
        url: 'https://aws.com',
        version: '',
        integration: '',
        isCollectionCard: true,
        onCardClick: createCollectionCardHandler('aws')
      }, {
        id: 'gcp-logs-generated',
        type: 'generated',
        title: 'Google Cloud Platform',
        description: 'Collect logs from Google Cloud Platform',
        name: 'gcp',
        categories: ['observability'],
        icons: [],
        url: '',
        version: '',
        integration: '',
        isCollectionCard: true,
        onCardClick: createCollectionCardHandler('gcp')
      }];
    default:
      return undefined;
  }
}