"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Header = void 0;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _useAsync = _interopRequireDefault(require("react-use/lib/useAsync"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Header = () => {
  var _currentUser$value$fu;
  const {
    services
  } = (0, _public.useKibana)();
  const currentUser = (0, _useAsync.default)(services.security.authc.getCurrentUser);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonTitle, {
    size: "xs",
    isLoading: currentUser.loading,
    announceLoadingStatus: false,
    announceLoadedStatus: false
  }, currentUser.value && /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "subdued"
  }, _i18n.i18n.translate('xpack.observability_onboarding.experimentalOnboardingFlow.h1.hiJohnLabel', {
    defaultMessage: 'Hi {username}!',
    values: {
      username: (_currentUser$value$fu = currentUser.value.full_name) !== null && _currentUser$value$fu !== void 0 ? _currentUser$value$fu : currentUser.value.username
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "l"
  }, /*#__PURE__*/_react.default.createElement("h1", null, _i18n.i18n.translate('xpack.observability_onboarding.experimentalOnboardingFlow.addObservabilityDataTitleLabel', {
    defaultMessage: 'Add Observability data'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued"
  }, _i18n.i18n.translate('xpack.observability_onboarding.experimentalOnboardingFlow.startIngestingDataIntoTextLabel', {
    defaultMessage: 'Start ingesting data into your Observability project. Return to this page at any time by clicking Add data.'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null));
};
exports.Header = Header;