"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ObservabilityOnboardingAppRoot = ObservabilityOnboardingAppRoot;
exports.renderApp = exports.onBoardingTitle = exports.breadcrumbsApp = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _public = require("@kbn/core/public");
var _i18n = require("@kbn/i18n");
var _public2 = require("@kbn/kibana-react-plugin/public");
var _sharedUxLinkRedirectApp = require("@kbn/shared-ux-link-redirect-app");
var _public3 = require("@kbn/observability-shared-plugin/public");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _uiTheme = require("@kbn/ui-theme");
var _react2 = _interopRequireDefault(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _telemetry_events = require("../../common/telemetry_events");
var _custom_logs = require("../components/app/custom_logs");
var _system_logs = require("../components/app/system_logs");
var _header_action_menu = require("../components/app/header_action_menu");
var _routes = require("../routes");
var _custom_logs2 = require("../routes/templates/custom_logs");
var _system_logs2 = require("../routes/templates/system_logs");
var _experimental_onboarding_flow = require("./experimental_onboarding_flow");
var _experimental_onboarding_enabled = require("../context/experimental_onboarding_enabled");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const onBoardingTitle = exports.onBoardingTitle = _i18n.i18n.translate('xpack.observability_onboarding.breadcrumbs.onboarding', {
  defaultMessage: 'Onboarding'
});
const breadcrumbsApp = exports.breadcrumbsApp = {
  id: 'observabilityOnboarding',
  label: onBoardingTitle
};
function App() {
  const customLogRoutesPaths = Object.keys(_custom_logs.customLogsRoutes);
  const systemLogRoutesPaths = Object.keys(_system_logs.systemLogsRoutes);
  return /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_sharedUxRouter.Routes, null, Object.keys(_routes.baseRoutes).map(key => {
    const path = key;
    const {
      handler,
      exact
    } = _routes.routes[path];
    const Wrapper = () => {
      return handler();
    };
    return /*#__PURE__*/_react2.default.createElement(_sharedUxRouter.Route, {
      key: path,
      path: path,
      exact: exact,
      component: Wrapper
    });
  }), /*#__PURE__*/_react2.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: customLogRoutesPaths
  }, /*#__PURE__*/_react2.default.createElement(_custom_logs2.CustomLogs, null, customLogRoutesPaths.map(key => {
    const path = key;
    const {
      handler,
      exact
    } = _routes.routes[path];
    const Wrapper = () => {
      return handler();
    };
    return /*#__PURE__*/_react2.default.createElement(_sharedUxRouter.Route, {
      key: path,
      path: path,
      exact: exact,
      component: Wrapper
    });
  }))), /*#__PURE__*/_react2.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: systemLogRoutesPaths
  }, /*#__PURE__*/_react2.default.createElement(_system_logs2.SystemLogs, null, systemLogRoutesPaths.map(key => {
    const path = key;
    const {
      handler,
      exact
    } = _routes.routes[path];
    const Wrapper = () => {
      return handler();
    };
    return /*#__PURE__*/_react2.default.createElement(_sharedUxRouter.Route, {
      key: path,
      path: path,
      exact: exact,
      component: Wrapper
    });
  })))));
}
function ObservabilityOnboardingApp() {
  const darkMode = (0, _public2.useDarkMode)(false);
  return /*#__PURE__*/_react2.default.createElement(_react.ThemeProvider, {
    theme: outerTheme => ({
      ...outerTheme,
      eui: darkMode ? _uiTheme.euiDarkVars : _uiTheme.euiLightVars,
      darkMode
    })
  }, /*#__PURE__*/_react2.default.createElement("div", {
    className: _public.APP_WRAPPER_CLASS,
    "data-test-subj": "csmMainContainer"
  }, /*#__PURE__*/_react2.default.createElement(App, null)));
}
function ObservabilityOnboardingAppRoot({
  appMountParameters,
  core,
  deps,
  experimentalOnboardingFlowEnabled,
  corePlugins: {
    observability,
    data
  },
  config
}) {
  const {
    history,
    setHeaderActionMenu,
    theme$
  } = appMountParameters;
  const i18nCore = core.i18n;
  const plugins = {
    ...deps
  };
  const renderFeedbackLinkAsPortal = !config.serverless.enabled;
  core.analytics.reportEvent(_telemetry_events.OBSERVABILITY_ONBOARDING_TELEMETRY_EVENT.eventType, {
    uses_legacy_onboarding_page: !experimentalOnboardingFlowEnabled
  });
  return /*#__PURE__*/_react2.default.createElement("div", {
    className: _public.APP_WRAPPER_CLASS
  }, /*#__PURE__*/_react2.default.createElement(_sharedUxLinkRedirectApp.RedirectAppLinks, {
    coreStart: {
      application: core.application
    }
  }, /*#__PURE__*/_react2.default.createElement(_public2.KibanaContextProvider, {
    services: {
      ...core,
      ...plugins,
      observability,
      data,
      config
    }
  }, /*#__PURE__*/_react2.default.createElement(_public2.KibanaThemeProvider, {
    theme$: theme$,
    modify: {
      breakpoint: {
        xxl: 1600,
        xxxl: 2000
      }
    }
  }, /*#__PURE__*/_react2.default.createElement(i18nCore.Context, null, /*#__PURE__*/_react2.default.createElement(_sharedUxRouter.Router, {
    history: history
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiErrorBoundary, null, renderFeedbackLinkAsPortal && /*#__PURE__*/_react2.default.createElement(_public3.HeaderMenuPortal, {
    setHeaderActionMenu: setHeaderActionMenu,
    theme$: theme$
  }, /*#__PURE__*/_react2.default.createElement(_header_action_menu.ObservabilityOnboardingHeaderActionMenu, null)), /*#__PURE__*/_react2.default.createElement(_experimental_onboarding_enabled.ExperimentalOnboardingFeatureFlag.Provider, {
    value: experimentalOnboardingFlowEnabled
  }, experimentalOnboardingFlowEnabled ? /*#__PURE__*/_react2.default.createElement(_experimental_onboarding_flow.ExperimentalOnboardingFlow, null) : /*#__PURE__*/_react2.default.createElement(ObservabilityOnboardingApp, null)))))))));
}

/**
 * This module is rendered asynchronously in the Kibana platform.
 */

const renderApp = props => {
  const {
    element
  } = props.appMountParameters;
  _reactDom.default.render( /*#__PURE__*/_react2.default.createElement(ObservabilityOnboardingAppRoot, props), element);
  return () => {
    props.corePlugins.data.search.session.clear();
    _reactDom.default.unmountComponentAtNode(element);
  };
};
exports.renderApp = renderApp;