"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDocTitle = getDocTitle;
exports.noBreadcrumbs = void 0;
exports.setBreadcrumbs = setBreadcrumbs;
exports.useBreadcrumbs = void 0;
var _deeplinksObservability = require("@kbn/deeplinks-observability");
var _public = require("@kbn/observability-shared-plugin/public");
var _react = require("react");
var _translations = require("../../common/translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useBreadcrumbs = (breadcrumbs, chromeService, serverlessService) => {
  const observabilityLinkProps = (0, _public.useLinkProps)({
    app: _deeplinksObservability.OBSERVABILITY_OVERVIEW_APP_ID
  });
  const logsLinkProps = (0, _public.useLinkProps)({
    app: _deeplinksObservability.LOGS_APP_ID
  });
  const logsExplorerLinkProps = (0, _public.useLinkProps)({
    app: _deeplinksObservability.OBSERVABILITY_LOGS_EXPLORER_APP_ID
  });
  (0, _react.useEffect)(() => {
    setBreadcrumbs(serverlessService ? breadcrumbs : [{
      text: _translations.observabilityAppTitle,
      ...observabilityLinkProps
    }, {
      text: _translations.logsAppTitle,
      ...logsLinkProps
    }, {
      text: _translations.logsExplorerAppTitle,
      ...logsExplorerLinkProps
    }, ...breadcrumbs], chromeService, serverlessService);
  }, [breadcrumbs, chromeService, serverlessService]); // eslint-disable-line react-hooks/exhaustive-deps
};
exports.useBreadcrumbs = useBreadcrumbs;
function setBreadcrumbs(breadcrumbs, chromeService, serverlessService) {
  chromeService.docTitle.change(getDocTitle(breadcrumbs));
  if (serverlessService) {
    serverlessService.setBreadcrumbs(breadcrumbs);
  } else if (chromeService) {
    chromeService.setBreadcrumbs(breadcrumbs);
  }
}
function getDocTitle(breadcrumbs) {
  return breadcrumbs.map(({
    text
  }) => text).reverse();
}
const noBreadcrumbs = exports.noBreadcrumbs = [];