"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateUrlFromDatasetQualityState = exports.initializeFromUrl = void 0;
var _ioTsUtils = require("@kbn/io-ts-utils");
var _public = require("@kbn/kibana-utils-plugin/public");
var Either = _interopRequireWildcard(require("fp-ts/lib/Either"));
var rt = _interopRequireWildcard(require("io-ts"));
var _common = require("../../../../common");
var urlSchemaV1 = _interopRequireWildcard(require("./url_schema_v1"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const updateUrlFromDatasetQualityState = ({
  urlStateStorageContainer
}) => (context, event) => {
  if (!('datasetQualityState' in context)) {
    return;
  }
  const encodedUrlStateValues = urlSchemaV1.stateFromUntrustedUrlRT.encode(context.datasetQualityState);
  urlStateStorageContainer.set(_common.OBSERVABILITY_DATASET_QUALITY_URL_STATE_KEY, encodedUrlStateValues, {
    replace: true
  });
};
exports.updateUrlFromDatasetQualityState = updateUrlFromDatasetQualityState;
const initializeFromUrl = ({
  toastsService,
  urlStateStorageContainer
}) => (_context, _event) => send => {
  var _urlStateStorageConta;
  const urlStateValues = (_urlStateStorageConta = urlStateStorageContainer.get(_common.OBSERVABILITY_DATASET_QUALITY_URL_STATE_KEY)) !== null && _urlStateStorageConta !== void 0 ? _urlStateStorageConta : undefined;
  const stateValuesE = rt.union([rt.undefined, urlSchemaV1.stateFromUntrustedUrlRT]).decode(urlStateValues);
  if (Either.isLeft(stateValuesE)) {
    (0, _public.withNotifyOnErrors)(toastsService).onGetError((0, _ioTsUtils.createPlainError)((0, _ioTsUtils.formatErrors)(stateValuesE.left)));
    send({
      type: 'INITIALIZED_FROM_URL',
      stateFromUrl: undefined
    });
  } else {
    send({
      type: 'INITIALIZED_FROM_URL',
      stateFromUrl: stateValuesE.right
    });
  }
};
exports.initializeFromUrl = initializeFromUrl;