"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DatasetQualityRoute = void 0;
var _eui = require("@elastic/eui");
var _deeplinksObservability = require("@kbn/deeplinks-observability");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/observability-shared-plugin/public");
var _react = require("@xstate/react");
var _react2 = _interopRequireDefault(require("react"));
var _page_template = require("../../components/page_template");
var _provider = require("../../state_machines/dataset_quality/src/provider");
var _breadcrumbs = require("../../utils/breadcrumbs");
var _kbn_url_state_context = require("../../utils/kbn_url_state_context");
var _use_kibana = require("../../utils/use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DatasetQualityRoute = () => {
  const {
    services
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const {
    datasetQuality,
    serverless,
    chrome,
    notifications
  } = services;
  const logsExplorerLinkProps = (0, _public.useLinkProps)({
    app: _deeplinksObservability.OBSERVABILITY_LOGS_EXPLORER_APP_ID
  });
  (0, _breadcrumbs.useBreadcrumbs)([{
    text: 'Datasets',
    ...logsExplorerLinkProps
  }], chrome, serverless);
  const urlStateStorageContainer = (0, _kbn_url_state_context.useKbnUrlStateStorageFromRouterContext)();
  return /*#__PURE__*/_react2.default.createElement(_provider.ObservabilityDatasetQualityPageStateProvider, {
    createDatasetQualityController: initialState => datasetQuality.createDatasetQualityController(initialState),
    toasts: notifications.toasts,
    urlStateStorageContainer: urlStateStorageContainer
  }, /*#__PURE__*/_react2.default.createElement(ConnectedContent, null));
};
exports.DatasetQualityRoute = DatasetQualityRoute;
const ConnectedContent = /*#__PURE__*/_react2.default.memo(() => {
  const {
    services: {
      datasetQuality
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const [state] = (0, _react.useActor)((0, _provider.useObservabilityDatasetQualityPageStateContext)());
  if (state.matches('initialized')) {
    return /*#__PURE__*/_react2.default.createElement(InitializedContent, {
      datasetQualityController: state.context.controller,
      datasetQuality: datasetQuality
    });
  } else {
    return /*#__PURE__*/_react2.default.createElement(InitializingContent, null);
  }
});
const InitializingContent = /*#__PURE__*/_react2.default.memo(() => /*#__PURE__*/_react2.default.createElement(_page_template.ObservabilityLogsExplorerPageTemplate, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiEmptyPrompt, {
  icon: /*#__PURE__*/_react2.default.createElement(_eui.EuiLoadingLogo, {
    logo: "logoKibana",
    size: "xl"
  }),
  title: /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.observabilityLogsExplorer.datasetQuality.InitializingTitle",
    defaultMessage: "Initializing the Dataset Quality"
  })
})));
const InitializedContent = /*#__PURE__*/_react2.default.memo(({
  datasetQuality,
  datasetQualityController
}) => {
  return /*#__PURE__*/_react2.default.createElement(_page_template.ObservabilityLogsExplorerPageTemplate, {
    pageSectionProps: {
      paddingSize: 'l'
    }
  }, /*#__PURE__*/_react2.default.createElement(datasetQuality.DatasetQuality, {
    controller: datasetQualityController
  }));
});