"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createOnUknownDataViewSelectionHandler = void 0;
var _common = require("@kbn/logs-explorer-plugin/common");
var _public = require("@kbn/logs-explorer-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createOnUknownDataViewSelectionHandler = discover => {
  return context => {
    var _discover$locator, _context$chart$breakd;
    if ((0, _common.isDataViewSelection)(context.dataSourceSelection)) (_discover$locator = discover.locator) === null || _discover$locator === void 0 ? void 0 : _discover$locator.navigate({
      breakdownField: (_context$chart$breakd = context.chart.breakdownField) !== null && _context$chart$breakd !== void 0 ? _context$chart$breakd : undefined,
      columns: (0, _public.getDiscoverColumnsWithFallbackFieldsFromDisplayOptions)(context),
      dataViewSpec: context.dataSourceSelection.selection.dataView.toDataviewSpec(),
      filters: context.filters,
      query: context.query,
      refreshInterval: context.refreshInterval,
      timeRange: context.time
    });
  };
};
exports.createOnUknownDataViewSelectionHandler = createOnUknownDataViewSelectionHandler;