"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertsPopover = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _react2 = require("@xstate/react");
var _common = require("@kbn/logs-explorer-plugin/common");
var _esQuery = require("@kbn/es-query");
var _public = require("@kbn/logs-explorer-plugin/public");
var _public2 = require("@kbn/observability-shared-plugin/public");
var _common2 = require("@kbn/observability-shared-plugin/common");
var _public3 = require("@kbn/triggers-actions-ui-plugin/public");
var _useAsync = _interopRequireDefault(require("react-use/lib/useAsync"));
var _use_kibana = require("../utils/use_kibana");
var _src = require("../state_machines/observability_logs_explorer/src");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function alertsPopoverReducer(state, action) {
  var _action$isOpen, _action$isOpen2, _action$isOpen3;
  switch (action.type) {
    case 'togglePopover':
      return {
        isPopoverOpen: (_action$isOpen = action.isOpen) !== null && _action$isOpen !== void 0 ? _action$isOpen : !state.isPopoverOpen,
        isAddRuleFlyoutOpen: state.isAddRuleFlyoutOpen,
        isCreateSLOFlyoutOpen: state.isCreateSLOFlyoutOpen
      };
    case 'toggleAddRuleFlyout':
      return {
        isPopoverOpen: false,
        isAddRuleFlyoutOpen: (_action$isOpen2 = action.isOpen) !== null && _action$isOpen2 !== void 0 ? _action$isOpen2 : !state.isAddRuleFlyoutOpen,
        isCreateSLOFlyoutOpen: false
      };
    case 'toggleCreateSLOFlyout':
      return {
        isPopoverOpen: false,
        isAddRuleFlyoutOpen: false,
        isCreateSLOFlyoutOpen: (_action$isOpen3 = action.isOpen) !== null && _action$isOpen3 !== void 0 ? _action$isOpen3 : !state.isAddRuleFlyoutOpen
      };
    default:
      return state;
  }
}
const defaultQuery = {
  language: 'kuery',
  query: ''
};
function getQuery(query) {
  if (query && (0, _esQuery.isOfQueryType)(query)) {
    return query;
  }
  return defaultQuery;
}
const AlertsPopover = () => {
  var _application$capabili;
  const {
    services: {
      triggersActionsUi,
      slo,
      application,
      http
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const manageRulesLinkProps = (0, _public2.useLinkProps)({
    app: 'observability',
    pathname: '/alerts/rules'
  });
  const [pageState] = (0, _react2.useActor)((0, _src.useObservabilityLogsExplorerPageStateContext)());
  const [state, dispatch] = (0, _react.useReducer)(alertsPopoverReducer, {
    isPopoverOpen: false,
    isAddRuleFlyoutOpen: false,
    isCreateSLOFlyoutOpen: false
  });
  const togglePopover = () => dispatch({
    type: 'togglePopover'
  });
  const closePopover = () => dispatch({
    type: 'togglePopover',
    isOpen: false
  });
  const openAddRuleFlyout = () => dispatch({
    type: 'toggleAddRuleFlyout',
    isOpen: true
  });
  const closeAddRuleFlyout = () => dispatch({
    type: 'toggleAddRuleFlyout',
    isOpen: false
  });
  const openCreateSLOFlyout = () => dispatch({
    type: 'toggleCreateSLOFlyout',
    isOpen: true
  });
  const closeCreateSLOFlyout = () => dispatch({
    type: 'toggleCreateSLOFlyout',
    isOpen: false
  });
  const addRuleFlyout = (0, _react.useMemo)(() => {
    if (state.isAddRuleFlyoutOpen && triggersActionsUi && pageState.matches({
      initialized: 'validLogsExplorerState'
    })) {
      const {
        logsExplorerState
      } = pageState.context;
      const index = (0, _common.hydrateDataSourceSelection)(logsExplorerState.dataSourceSelection).toDataviewSpec();
      return triggersActionsUi.getAddRuleFlyout({
        consumer: 'logs',
        ruleTypeId: _ruleDataUtils.OBSERVABILITY_THRESHOLD_RULE_TYPE_ID,
        canChangeTrigger: false,
        initialValues: {
          params: {
            searchConfiguration: {
              index,
              query: getQuery(logsExplorerState.query),
              filter: (0, _public.getDiscoverFiltersFromState)(index.id, logsExplorerState.filters, logsExplorerState.controls)
            }
          }
        },
        onClose: closeAddRuleFlyout
      });
    }
  }, [triggersActionsUi, pageState, state.isAddRuleFlyoutOpen]);
  const createSLOFlyout = (0, _react.useMemo)(() => {
    if (state.isCreateSLOFlyoutOpen && pageState.matches({
      initialized: 'validLogsExplorerState'
    })) {
      var _logsExplorerState$ch;
      const {
        logsExplorerState
      } = pageState.context;
      const dataView = (0, _common.hydrateDataSourceSelection)(logsExplorerState.dataSourceSelection).toDataviewSpec();
      const query = logsExplorerState !== null && logsExplorerState !== void 0 && logsExplorerState.query && 'query' in logsExplorerState.query ? String(logsExplorerState.query.query) : undefined;
      return slo.getCreateSLOFlyout({
        initialValues: {
          indicator: {
            type: 'sli.kql.custom',
            params: {
              index: dataView.title,
              timestampField: dataView === null || dataView === void 0 ? void 0 : dataView.timeFieldName,
              filter: {
                kqlQuery: query,
                filters: (0, _public.getDiscoverFiltersFromState)(dataView.id, logsExplorerState.filters, logsExplorerState.controls)
              }
            }
          },
          groupBy: (_logsExplorerState$ch = logsExplorerState.chart.breakdownField) !== null && _logsExplorerState$ch !== void 0 ? _logsExplorerState$ch : undefined
        },
        onClose: closeCreateSLOFlyout
      });
    }
  }, [slo, pageState, state.isCreateSLOFlyoutOpen]);

  // Check whether the user has the necessary permissions to create an SLO
  const canCreateSLOs = !!((_application$capabili = application.capabilities[_common2.sloFeatureId]) !== null && _application$capabili !== void 0 && _application$capabili.write);

  // Check whether the user has the necessary permissions to create a rule
  const canCreateRuleState = (0, _useAsync.default)(async () => {
    const ruleTypes = await (0, _public3.loadRuleTypes)({
      http
    });
    const customThresholdRuleType = ruleTypes.find(ruleType => ruleType.id === _ruleDataUtils.OBSERVABILITY_THRESHOLD_RULE_TYPE_ID);
    if (customThresholdRuleType) {
      var _customThresholdRuleT;
      return (_customThresholdRuleT = customThresholdRuleType.authorizedConsumers.logs) === null || _customThresholdRuleT === void 0 ? void 0 : _customThresholdRuleT.all;
    }
    return false;
  });
  const items = [];
  if (canCreateRuleState.value) {
    items.push( /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: "createRule",
      icon: "bell",
      onClick: openAddRuleFlyout
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.observabilityLogsExplorer.alertsPopover.createRuleMenuItem",
      defaultMessage: "Create rule"
    })));
  }
  if (canCreateSLOs) {
    items.push( /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: "createSLO",
      icon: "visGauge",
      onClick: openCreateSLOFlyout
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.observabilityLogsExplorer.alertsPopover.createSLOMenuItem",
      defaultMessage: "Create SLO"
    })));
  }
  if (items.length > 0) {
    items.push( /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
      key: "horizontalRule",
      margin: "none"
    }));
  }
  items.push( /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, (0, _extends2.default)({
    key: "manageRules",
    icon: "tableOfContents"
  }, manageRulesLinkProps), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.observabilityLogsExplorer.alertsPopover.manageRulesMenuItem",
    defaultMessage: "{canCreateRule, select, true{Manage} other{View}} rules",
    values: {
      canCreateRule: canCreateRuleState.value
    }
  })));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, addRuleFlyout, createSLOFlyout, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "observabilityLogsExplorerAlertsPopoverAlertsButton",
      onClick: togglePopover,
      iconType: "arrowDown",
      iconSide: "right",
      isLoading: canCreateRuleState.loading
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.observabilityLogsExplorer.alertsPopover.buttonLabel",
      defaultMessage: "Alerts"
    })),
    isOpen: state.isPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "none",
    anchorPosition: "downLeft"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    items: items
  })));
};
exports.AlertsPopover = AlertsPopover;