"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderObservabilityLogsExplorerRedirect = exports.ObservabilityLogsExplorerRedirect = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _reactRouterDom = require("react-router-dom");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _deeplinksObservability = require("@kbn/deeplinks-observability");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const renderObservabilityLogsExplorerRedirect = (core, appParams) => {
  _reactDom.default.render( /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Router, {
    history: appParams.history
  }, /*#__PURE__*/_react.default.createElement(ObservabilityLogsExplorerRedirect, {
    core: core
  })), appParams.element);
  return () => {
    _reactDom.default.unmountComponentAtNode(appParams.element);
  };
};
exports.renderObservabilityLogsExplorerRedirect = renderObservabilityLogsExplorerRedirect;
const ObservabilityLogsExplorerRedirect = ({
  core
}) => {
  const location = (0, _reactRouterDom.useLocation)();
  const path = `${location.pathname}${location.search}`;
  core.application.navigateToApp(_deeplinksObservability.OBSERVABILITY_LOGS_EXPLORER_APP_ID, {
    replace: true,
    path
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
};
exports.ObservabilityLogsExplorerRedirect = ObservabilityLogsExplorerRedirect;