"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.urlSchemaRT = exports.timeRangeRT = exports.refreshIntervalRT = exports.queryRT = exports.optionsListControlRT = exports.filtersRT = exports.filterRT = exports.filterMetaRT = exports.controlsRT = exports.columnsRT = exports.columnRT = void 0;
var _common = require("@kbn/logs-explorer-plugin/common");
var rt = _interopRequireWildcard(require("io-ts"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const allowedNamesRT = rt.keyof({
  content: null,
  resource: null
});

// Define the runtime type for DocumentFieldGridColumnOptions
const documentFieldColumnRT = rt.intersection([rt.strict({
  type: rt.literal('document-field'),
  field: rt.string
}), rt.exact(rt.partial({
  width: rt.number
}))]);

// Define the runtime type for SmartFieldGridColumnOptions
const smartFieldColumnRT = rt.intersection([rt.strict({
  type: rt.literal('smart-field'),
  smartField: allowedNamesRT,
  fallbackFields: rt.array(rt.string)
}), rt.exact(rt.partial({
  width: rt.number
}))]);
const columnRT = exports.columnRT = rt.union([documentFieldColumnRT, smartFieldColumnRT]);
const columnsRT = exports.columnsRT = rt.array(columnRT);
const optionsListControlRT = exports.optionsListControlRT = rt.strict({
  mode: rt.keyof({
    exclude: null,
    include: null
  }),
  selection: rt.union([rt.strict({
    type: rt.literal('exists')
  }), rt.strict({
    type: rt.literal('options'),
    selectedOptions: rt.array(rt.string)
  })])
});
const controlsRT = exports.controlsRT = rt.exact(rt.partial({
  [_common.availableControlsPanels.NAMESPACE]: optionsListControlRT
}));
const filterMetaRT = exports.filterMetaRT = rt.partial({
  alias: rt.union([rt.string, rt.null]),
  disabled: rt.boolean,
  negate: rt.boolean,
  controlledBy: rt.string,
  group: rt.string,
  index: rt.string,
  isMultiIndex: rt.boolean,
  type: rt.string,
  key: rt.string,
  params: rt.any,
  value: rt.any
});
const filterRT = exports.filterRT = rt.intersection([rt.strict({
  meta: filterMetaRT
}), rt.exact(rt.partial({
  query: rt.UnknownRecord
}))]);
const filtersRT = exports.filtersRT = rt.array(filterRT);
const queryRT = exports.queryRT = rt.union([rt.strict({
  language: rt.string,
  query: rt.union([rt.string, rt.record(rt.string, rt.unknown)])
}), rt.strict({
  sql: rt.string
}), rt.strict({
  esql: rt.string
})]);
const timeRangeRT = exports.timeRangeRT = rt.intersection([rt.strict({
  from: rt.string,
  to: rt.string
}), rt.exact(rt.partial({
  mode: rt.keyof({
    absolute: null,
    relative: null
  })
}))]);
const refreshIntervalRT = exports.refreshIntervalRT = rt.strict({
  pause: rt.boolean,
  value: rt.number
});
const urlSchemaRT = exports.urlSchemaRT = rt.exact(rt.partial({
  v: rt.literal(1),
  breakdownField: rt.union([rt.string, rt.null]),
  columns: columnsRT,
  datasetSelection: _common.dataSourceSelectionPlainRT,
  filters: filtersRT,
  query: queryRT,
  refreshInterval: refreshIntervalRT,
  rowHeight: rt.number,
  rowsPerPage: rt.number,
  time: timeRangeRT,
  controls: controlsRT
}));