"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.eventsourceStreamIntoObservable = eventsourceStreamIntoObservable;
var _eventsourceParser = require("eventsource-parser");
var _rxjs = require("rxjs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// OpenAI sends server-sent events, so we can use a library
// to deal with parsing, buffering, unicode etc

function eventsourceStreamIntoObservable(readable) {
  return new _rxjs.Observable(subscriber => {
    const parser = (0, _eventsourceParser.createParser)(event => {
      if (event.type === 'event') {
        subscriber.next(event.data);
      }
    });
    async function processStream() {
      for await (const chunk of readable) {
        parser.feed(chunk.toString());
      }
    }
    processStream().then(() => {
      subscriber.complete();
    }, error => {
      subscriber.error(error);
    });
  });
}