"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.instrumentAndCountTokens = instrumentAndCountTokens;
var _elasticApmNode = _interopRequireDefault(require("elastic-apm-node"));
var _rxjs = require("rxjs");
var _extract_token_count = require("./extract_token_count");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function instrumentAndCountTokens(name) {
  return source$ => {
    const span = _elasticApmNode.default.startSpan(name);
    if (!span) {
      return source$;
    }
    span === null || span === void 0 ? void 0 : span.addLabels({
      plugin: 'observability_ai_assistant'
    });
    const shared$ = source$.pipe((0, _rxjs.shareReplay)());
    let tokenCount = {
      prompt: 0,
      completion: 0,
      total: 0
    };
    return (0, _rxjs.merge)(shared$, shared$.pipe((0, _extract_token_count.extractTokenCount)(), (0, _rxjs.tap)(nextTokenCount => {
      tokenCount = nextTokenCount;
    }), (0, _rxjs.last)(), (0, _rxjs.tap)(() => {
      span === null || span === void 0 ? void 0 : span.setOutcome('success');
    }), (0, _rxjs.catchError)(error => {
      span === null || span === void 0 ? void 0 : span.setOutcome('failure');
      return (0, _rxjs.throwError)(() => error);
    }), (0, _rxjs.finalize)(() => {
      span === null || span === void 0 ? void 0 : span.addLabels({
        tokenCountPrompt: tokenCount.prompt,
        tokenCountCompletion: tokenCount.completion,
        tokenCountTotal: tokenCount.total
      });
      span === null || span === void 0 ? void 0 : span.end();
    }), (0, _rxjs.ignoreElements)()));
  };
}