"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getGeneratedTitle = getGeneratedTitle;
var _rxjs = require("rxjs");
var _common = require("../../../../common");
var _concatenate_chat_completion_chunks = require("../../../../common/utils/concatenate_chat_completion_chunks");
var _hide_token_count_events = require("./hide_token_count_events");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getGeneratedTitle({
  responseLanguage,
  messages,
  chat,
  logger
}) {
  return (0, _hide_token_count_events.hideTokenCountEvents)(hide => chat('generate_title', {
    messages: [{
      '@timestamp': new Date().toString(),
      message: {
        role: _common.MessageRole.System,
        content: `You are a helpful assistant for Elastic Observability. Assume the following message is the start of a conversation between you and a user; give this conversation a title based on the content below. DO NOT UNDER ANY CIRCUMSTANCES wrap this title in single or double quotes. This title is shown in a list of conversations to the user, so title it for the user, not for you. Please create the title in ${responseLanguage}.`
      }
    }, {
      '@timestamp': new Date().toISOString(),
      message: {
        role: _common.MessageRole.User,
        content: messages.filter(msg => msg.message.role !== _common.MessageRole.System).reduce((acc, curr) => {
          return `${acc} ${curr.message.role}: ${curr.message.content}`;
        }, 'Generate a title, using the title_conversation_function, based on the following conversation:\n\n')
      }
    }],
    functions: [{
      name: 'title_conversation',
      description: 'Use this function to title the conversation. Do not wrap the title in quotes',
      parameters: {
        type: 'object',
        properties: {
          title: {
            type: 'string'
          }
        },
        required: ['title']
      }
    }],
    functionCall: 'title_conversation'
  }).pipe(hide(), (0, _concatenate_chat_completion_chunks.concatenateChatCompletionChunks)(), (0, _rxjs.last)(), (0, _rxjs.map)(concatenatedMessage => {
    var _concatenatedMessage$;
    const title = (concatenatedMessage.message.function_call.name ? JSON.parse(concatenatedMessage.message.function_call.arguments).title : (_concatenatedMessage$ = concatenatedMessage.message) === null || _concatenatedMessage$ === void 0 ? void 0 : _concatenatedMessage$.content) || '';

    // This captures a string enclosed in single or double quotes.
    // It extracts the string content without the quotes.
    // Example matches:
    // - "Hello, World!" => Captures: Hello, World!
    // - 'Another Example' => Captures: Another Example
    // - JustTextWithoutQuotes => Captures: JustTextWithoutQuotes

    return title.replace(/^"(.*)"$/g, '$1').replace(/^'(.*)'$/g, '$1');
  }), (0, _rxjs.tap)(event => {
    if (typeof event === 'string') {
      logger.debug(`Generated title: ${event}`);
    }
  }))).pipe((0, _rxjs.catchError)(error => {
    logger.error(`Error generating title`);
    logger.error(error);
    // TODO: i18n
    return (0, _rxjs.of)('New conversation');
  }));
}