"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.extractTokenCount = extractTokenCount;
var _rxjs = require("rxjs");
var _conversation_complete = require("../../../../common/conversation_complete");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function extractTokenCount() {
  return events$ => {
    return events$.pipe((0, _rxjs.filter)(event => event.type === _conversation_complete.StreamingChatResponseEventType.TokenCount), (0, _rxjs.scan)((acc, event) => {
      acc.completion += event.tokens.completion;
      acc.prompt += event.tokens.prompt;
      acc.total += event.tokens.total;
      return acc;
    }, {
      completion: 0,
      prompt: 0,
      total: 0
    }));
  };
}