"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.catchFunctionNotFoundError = catchFunctionNotFoundError;
var _rxjs = require("rxjs");
var _conversation_complete = require("../../../../common/conversation_complete");
var _create_server_side_function_response_error = require("../../util/create_server_side_function_response_error");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function catchFunctionNotFoundError() {
  return (0, _rxjs.catchError)(error => {
    if ((0, _conversation_complete.isFunctionNotFoundError)(error)) {
      const functionLimitExceededError = (0, _conversation_complete.createFunctionLimitExceededError)();
      return (0, _rxjs.of)((0, _create_server_side_function_response_error.createServerSideFunctionResponseError)({
        name: error.meta.name,
        error: functionLimitExceededError
      }));
    }
    return (0, _rxjs.throwError)(() => error);
  });
}