"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.functionRoutes = void 0;
var _boom = require("@hapi/boom");
var _ioTsUtils = require("@kbn/io-ts-utils");
var t = _interopRequireWildcard(require("io-ts"));
var _types = require("../../../common/types");
var _get_system_message_from_instructions = require("../../service/util/get_system_message_from_instructions");
var _create_observability_ai_assistant_server_route = require("../create_observability_ai_assistant_server_route");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getFunctionsRoute = (0, _create_observability_ai_assistant_server_route.createObservabilityAIAssistantServerRoute)({
  endpoint: 'GET /internal/observability_ai_assistant/functions',
  options: {
    tags: ['access:ai_assistant']
  },
  handler: async resources => {
    const {
      service,
      request
    } = resources;
    const controller = new AbortController();
    request.events.aborted$.subscribe(() => {
      controller.abort();
    });
    const client = await service.getClient({
      request
    });
    const [functionClient, knowledgeBaseInstructions] = await Promise.all([service.getFunctionClient({
      signal: controller.signal,
      resources,
      client,
      screenContexts: []
    }),
    // error is caught in client
    client.fetchKnowledgeBaseInstructions()]);
    const functionDefinitions = functionClient.getFunctions().map(fn => fn.definition);
    const availableFunctionNames = functionDefinitions.map(def => def.name);
    return {
      functionDefinitions: functionClient.getFunctions().map(fn => fn.definition),
      systemMessage: (0, _get_system_message_from_instructions.getSystemMessageFromInstructions)({
        registeredInstructions: functionClient.getInstructions(),
        knowledgeBaseInstructions,
        requestInstructions: [],
        availableFunctionNames
      })
    };
  }
});
const functionRecallRoute = (0, _create_observability_ai_assistant_server_route.createObservabilityAIAssistantServerRoute)({
  endpoint: 'POST /internal/observability_ai_assistant/functions/recall',
  params: t.type({
    body: t.intersection([t.type({
      queries: t.array(_ioTsUtils.nonEmptyStringRt)
    }), t.partial({
      categories: t.array(t.string)
    })])
  }),
  options: {
    tags: ['access:ai_assistant']
  },
  handler: async resources => {
    const client = await resources.service.getClient({
      request: resources.request
    });
    const {
      body: {
        queries,
        categories
      }
    } = resources.params;
    if (!client) {
      throw (0, _boom.notImplemented)();
    }
    return client.recall({
      queries,
      categories
    });
  }
});
const functionSummariseRoute = (0, _create_observability_ai_assistant_server_route.createObservabilityAIAssistantServerRoute)({
  endpoint: 'POST /internal/observability_ai_assistant/functions/summarize',
  params: t.type({
    body: t.type({
      id: t.string,
      text: _ioTsUtils.nonEmptyStringRt,
      confidence: t.union([t.literal('low'), t.literal('medium'), t.literal('high')]),
      is_correction: _ioTsUtils.toBooleanRt,
      public: _ioTsUtils.toBooleanRt,
      labels: t.record(t.string, t.string)
    })
  }),
  options: {
    tags: ['access:ai_assistant']
  },
  handler: async resources => {
    const client = await resources.service.getClient({
      request: resources.request
    });
    if (!client) {
      throw (0, _boom.notImplemented)();
    }
    const {
      confidence,
      id,
      is_correction: isCorrection,
      text,
      public: isPublic,
      labels
    } = resources.params.body;
    return client.createKnowledgeBaseEntry({
      entry: {
        confidence,
        id,
        doc_id: id,
        is_correction: isCorrection,
        text,
        public: isPublic,
        labels,
        role: _types.KnowledgeBaseEntryRole.AssistantSummarization
      }
    });
  }
});
const functionRoutes = exports.functionRoutes = {
  ...getFunctionsRoute,
  ...functionRecallRoute,
  ...functionSummariseRoute
};