"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.conversationRoutes = void 0;
var _boom = require("@hapi/boom");
var t = _interopRequireWildcard(require("io-ts"));
var _create_observability_ai_assistant_server_route = require("../create_observability_ai_assistant_server_route");
var _runtime_types = require("../runtime_types");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getConversationRoute = (0, _create_observability_ai_assistant_server_route.createObservabilityAIAssistantServerRoute)({
  endpoint: 'GET /internal/observability_ai_assistant/conversation/{conversationId}',
  params: t.type({
    path: t.type({
      conversationId: t.string
    })
  }),
  options: {
    tags: ['access:ai_assistant']
  },
  handler: async resources => {
    const {
      service,
      request,
      params
    } = resources;
    const client = await service.getClient({
      request
    });
    if (!client) {
      throw (0, _boom.notImplemented)();
    }
    return client.get(params.path.conversationId);
  }
});
const findConversationsRoute = (0, _create_observability_ai_assistant_server_route.createObservabilityAIAssistantServerRoute)({
  endpoint: 'POST /internal/observability_ai_assistant/conversations',
  params: t.partial({
    body: t.partial({
      query: t.string
    })
  }),
  options: {
    tags: ['access:ai_assistant']
  },
  handler: async resources => {
    var _params$body;
    const {
      service,
      request,
      params
    } = resources;
    const client = await service.getClient({
      request
    });
    if (!client) {
      throw (0, _boom.notImplemented)();
    }
    return client.find({
      query: params === null || params === void 0 ? void 0 : (_params$body = params.body) === null || _params$body === void 0 ? void 0 : _params$body.query
    });
  }
});
const createConversationRoute = (0, _create_observability_ai_assistant_server_route.createObservabilityAIAssistantServerRoute)({
  endpoint: 'POST /internal/observability_ai_assistant/conversation',
  params: t.type({
    body: t.type({
      conversation: _runtime_types.conversationCreateRt
    })
  }),
  options: {
    tags: ['access:ai_assistant']
  },
  handler: async resources => {
    const {
      service,
      request,
      params
    } = resources;
    const client = await service.getClient({
      request
    });
    if (!client) {
      throw (0, _boom.notImplemented)();
    }
    return client.create(params.body.conversation);
  }
});
const updateConversationRoute = (0, _create_observability_ai_assistant_server_route.createObservabilityAIAssistantServerRoute)({
  endpoint: 'PUT /internal/observability_ai_assistant/conversation/{conversationId}',
  params: t.type({
    path: t.type({
      conversationId: t.string
    }),
    body: t.type({
      conversation: _runtime_types.conversationUpdateRt
    })
  }),
  options: {
    tags: ['access:ai_assistant']
  },
  handler: async resources => {
    const {
      service,
      request,
      params
    } = resources;
    const client = await service.getClient({
      request
    });
    if (!client) {
      throw (0, _boom.notImplemented)();
    }
    return client.update(params.path.conversationId, params.body.conversation);
  }
});
const updateConversationTitle = (0, _create_observability_ai_assistant_server_route.createObservabilityAIAssistantServerRoute)({
  endpoint: 'PUT /internal/observability_ai_assistant/conversation/{conversationId}/title',
  params: t.type({
    path: t.type({
      conversationId: t.string
    }),
    body: t.type({
      title: t.string
    })
  }),
  options: {
    tags: ['access:ai_assistant']
  },
  handler: async resources => {
    const {
      service,
      request,
      params
    } = resources;
    const client = await service.getClient({
      request
    });
    if (!client) {
      throw (0, _boom.notImplemented)();
    }
    const conversation = await client.setTitle({
      conversationId: params.path.conversationId,
      title: params.body.title
    });
    return Promise.resolve(conversation);
  }
});
const deleteConversationRoute = (0, _create_observability_ai_assistant_server_route.createObservabilityAIAssistantServerRoute)({
  endpoint: 'DELETE /internal/observability_ai_assistant/conversation/{conversationId}',
  params: t.type({
    path: t.type({
      conversationId: t.string
    })
  }),
  options: {
    tags: ['access:ai_assistant']
  },
  handler: async resources => {
    const {
      service,
      request,
      params
    } = resources;
    const client = await service.getClient({
      request
    });
    if (!client) {
      throw (0, _boom.notImplemented)();
    }
    return client.delete(params.path.conversationId);
  }
});
const conversationRoutes = exports.conversationRoutes = {
  ...getConversationRoute,
  ...findConversationsRoute,
  ...createConversationRoute,
  ...updateConversationRoute,
  ...updateConversationTitle,
  ...deleteConversationRoute
};