"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.chatRoutes = void 0;
var _boom = require("@hapi/boom");
var _ioTsUtils = require("@kbn/io-ts-utils");
var t = _interopRequireWildcard(require("io-ts"));
var _ = require("../..");
var _flush_buffer = require("../../service/util/flush_buffer");
var _observable_into_openai_stream = require("../../service/util/observable_into_openai_stream");
var _observable_into_stream = require("../../service/util/observable_into_stream");
var _create_observability_ai_assistant_server_route = require("../create_observability_ai_assistant_server_route");
var _runtime_types = require("../runtime_types");
var _with_assistant_span = require("../../service/util/with_assistant_span");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const chatCompleteBaseRt = t.type({
  body: t.intersection([t.type({
    messages: t.array(_runtime_types.messageRt),
    connectorId: t.string,
    persist: _ioTsUtils.toBooleanRt
  }), t.partial({
    conversationId: t.string,
    title: t.string,
    responseLanguage: t.string,
    disableFunctions: _ioTsUtils.toBooleanRt,
    instructions: t.array(t.union([t.string, t.type({
      doc_id: t.string,
      text: t.string
    })]))
  })])
});
const chatCompleteInternalRt = t.intersection([chatCompleteBaseRt, t.type({
  body: t.type({
    screenContexts: t.array(_runtime_types.screenContextRt)
  })
})]);
const chatCompletePublicRt = t.intersection([chatCompleteBaseRt, t.partial({
  body: t.partial({
    actions: t.array(_runtime_types.functionRt)
  }),
  query: t.partial({
    format: t.union([t.literal('default'), t.literal('openai')])
  })
})]);
async function guardAgainstInvalidConnector({
  actions,
  request,
  connectorId
}) {
  return (0, _with_assistant_span.withAssistantSpan)('guard_against_invalid_connector', async () => {
    const actionsClient = await actions.getActionsClientWithRequest(request);
    const connector = await actionsClient.get({
      id: connectorId,
      throwIfSystemAction: true
    });
    return connector;
  });
}
const chatRoute = (0, _create_observability_ai_assistant_server_route.createObservabilityAIAssistantServerRoute)({
  endpoint: 'POST /internal/observability_ai_assistant/chat',
  options: {
    tags: ['access:ai_assistant']
  },
  params: t.type({
    body: t.intersection([t.type({
      name: t.string,
      messages: t.array(_runtime_types.messageRt),
      connectorId: t.string,
      functions: t.array(_runtime_types.functionRt)
    }), t.partial({
      functionCall: t.string
    })])
  }),
  handler: async resources => {
    var _resources$plugins$cl;
    const {
      request,
      params,
      service,
      context,
      plugins
    } = resources;
    const {
      body: {
        name,
        messages,
        connectorId,
        functions,
        functionCall
      }
    } = params;
    await guardAgainstInvalidConnector({
      actions: await plugins.actions.start(),
      request,
      connectorId
    });
    const [client, cloudStart, simulateFunctionCalling] = await Promise.all([service.getClient({
      request
    }), (_resources$plugins$cl = resources.plugins.cloud) === null || _resources$plugins$cl === void 0 ? void 0 : _resources$plugins$cl.start(), (await context.core).uiSettings.client.get(_.aiAssistantSimulatedFunctionCalling)]);
    if (!client) {
      throw (0, _boom.notImplemented)();
    }
    const controller = new AbortController();
    request.events.aborted$.subscribe(() => {
      controller.abort();
    });
    const response$ = client.chat(name, {
      messages,
      connectorId,
      signal: controller.signal,
      ...(functions.length ? {
        functions,
        functionCall
      } : {}),
      simulateFunctionCalling
    });
    return (0, _observable_into_stream.observableIntoStream)(response$.pipe((0, _flush_buffer.flushBuffer)(!!(cloudStart !== null && cloudStart !== void 0 && cloudStart.isCloudEnabled))));
  }
});
async function chatComplete(resources) {
  var _resources$plugins$cl2;
  const {
    request,
    params,
    service,
    plugins
  } = resources;
  const {
    body: {
      messages,
      connectorId,
      conversationId,
      title,
      persist,
      screenContexts,
      responseLanguage,
      instructions,
      disableFunctions
    }
  } = params;
  await guardAgainstInvalidConnector({
    actions: await plugins.actions.start(),
    request,
    connectorId
  });
  const [client, cloudStart, simulateFunctionCalling] = await Promise.all([service.getClient({
    request
  }), ((_resources$plugins$cl2 = resources.plugins.cloud) === null || _resources$plugins$cl2 === void 0 ? void 0 : _resources$plugins$cl2.start()) || Promise.resolve(undefined), (await resources.context.core).uiSettings.client.get(_.aiAssistantSimulatedFunctionCalling)]);
  if (!client) {
    throw (0, _boom.notImplemented)();
  }
  const controller = new AbortController();
  request.events.aborted$.subscribe(() => {
    controller.abort();
  });
  const functionClient = await service.getFunctionClient({
    signal: controller.signal,
    resources,
    client,
    screenContexts
  });
  const response$ = client.complete({
    messages,
    connectorId,
    conversationId,
    title,
    persist,
    signal: controller.signal,
    functionClient,
    responseLanguage,
    instructions,
    simulateFunctionCalling,
    disableFunctions
  });
  return response$.pipe((0, _flush_buffer.flushBuffer)(!!(cloudStart !== null && cloudStart !== void 0 && cloudStart.isCloudEnabled)));
}
const chatCompleteRoute = (0, _create_observability_ai_assistant_server_route.createObservabilityAIAssistantServerRoute)({
  endpoint: 'POST /internal/observability_ai_assistant/chat/complete',
  options: {
    tags: ['access:ai_assistant']
  },
  params: chatCompleteInternalRt,
  handler: async resources => {
    return (0, _observable_into_stream.observableIntoStream)(await chatComplete(resources));
  }
});
const publicChatCompleteRoute = (0, _create_observability_ai_assistant_server_route.createObservabilityAIAssistantServerRoute)({
  endpoint: 'POST /api/observability_ai_assistant/chat/complete 2023-10-31',
  options: {
    tags: ['access:ai_assistant']
  },
  params: chatCompletePublicRt,
  handler: async resources => {
    const {
      params,
      logger
    } = resources;
    const {
      body: {
        actions,
        ...restOfBody
      },
      query = {}
    } = params;
    const {
      format = 'default'
    } = query;
    const response$ = await chatComplete({
      ...resources,
      params: {
        body: {
          ...restOfBody,
          screenContexts: [{
            actions
          }]
        }
      }
    });
    return format === 'openai' ? (0, _observable_into_openai_stream.observableIntoOpenAIStream)(response$, logger) : (0, _observable_into_stream.observableIntoStream)(response$);
  }
});
const chatRoutes = exports.chatRoutes = {
  ...chatRoute,
  ...chatCompleteRoute,
  ...publicChatCompleteRoute
};