"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRelevantFieldNames = getRelevantFieldNames;
var _datemath = _interopRequireDefault(require("@elastic/datemath"));
var _lodash = require("lodash");
var _rxjs = require("rxjs");
var _common = require("../../../common");
var _concatenate_chat_completion_chunks = require("../../../common/utils/concatenate_chat_completion_chunks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getRelevantFieldNames({
  index,
  start,
  end,
  dataViews,
  esClient,
  savedObjectsClient,
  chat,
  messages,
  signal
}) {
  const dataViewsService = await dataViews.dataViewsServiceFactory(savedObjectsClient, esClient);
  const fields = await dataViewsService.getFieldsForWildcard({
    pattern: (0, _lodash.castArray)(index).join(','),
    allowNoIndex: true,
    indexFilter: start && end ? {
      range: {
        '@timestamp': {
          gte: _datemath.default.parse(start).toISOString(),
          lt: _datemath.default.parse(end).toISOString()
        }
      }
    } : undefined
  });

  // else get all the fields for the found dataview
  const response = {
    indices: [index],
    fields: fields.flatMap(field => {
      var _field$esTypes;
      return ((_field$esTypes = field.esTypes) !== null && _field$esTypes !== void 0 ? _field$esTypes : [field.type]).map(type => {
        return {
          name: field.name,
          type
        };
      });
    })
  };
  const allFields = response.fields;
  const fieldNames = (0, _lodash.uniq)(allFields.map(field => field.name));
  const groupedFields = (0, _lodash.groupBy)(allFields, field => field.name);
  const relevantFields = await Promise.all((0, _lodash.chunk)(fieldNames, 500).map(async fieldsInChunk => {
    var _chunkResponse$messag, _chunkResponse$messag2, _chunkResponse$messag3, _chunkResponse$messag4;
    const chunkResponse$ = (await chat('get_relevent_dataset_names', {
      signal,
      messages: [{
        '@timestamp': new Date().toISOString(),
        message: {
          role: _common.MessageRole.System,
          content: `You are a helpful assistant for Elastic Observability.
            Your task is to create a list of field names that are relevant
            to the conversation, using ONLY the list of fields and
            types provided in the last user message. DO NOT UNDER ANY
            CIRCUMSTANCES include fields not mentioned in this list.`
        }
      }, ...messages.slice(1), {
        '@timestamp': new Date().toISOString(),
        message: {
          role: _common.MessageRole.User,
          content: `This is the list:

            ${fieldsInChunk.join('\n')}`
        }
      }],
      functions: [{
        name: 'fields',
        description: 'The fields you consider relevant to the conversation',
        parameters: {
          type: 'object',
          properties: {
            fields: {
              type: 'array',
              items: {
                type: 'string'
              }
            }
          },
          required: ['fields']
        }
      }],
      functionCall: 'fields'
    })).pipe((0, _concatenate_chat_completion_chunks.concatenateChatCompletionChunks)());
    const chunkResponse = await (0, _rxjs.lastValueFrom)(chunkResponse$);
    return (_chunkResponse$messag = chunkResponse.message) !== null && _chunkResponse$messag !== void 0 && (_chunkResponse$messag2 = _chunkResponse$messag.function_call) !== null && _chunkResponse$messag2 !== void 0 && _chunkResponse$messag2.arguments ? JSON.parse(chunkResponse.message.function_call.arguments).fields.filter(field => fieldsInChunk.includes(field)).map(field => {
      const fieldDescriptors = groupedFields[field];
      return `${field}:${fieldDescriptors.map(descriptor => descriptor.type).join(',')}`;
    }) : [(_chunkResponse$messag3 = (_chunkResponse$messag4 = chunkResponse.message) === null || _chunkResponse$messag4 === void 0 ? void 0 : _chunkResponse$messag4.content) !== null && _chunkResponse$messag3 !== void 0 ? _chunkResponse$messag3 : ''];
  }));
  return {
    fields: relevantFields.flat()
  };
}