"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.defaultStarterPrompts = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const defaultStarterPrompts = exports.defaultStarterPrompts = [{
  title: _i18n.i18n.translate('xpack.observabilityAiAssistant.app.starterPrompts.exampleQuestions.title', {
    defaultMessage: 'Suggest'
  }),
  prompt: _i18n.i18n.translate('xpack.observabilityAiAssistant.app.starterPrompts.exampleQuestions.prompt', {
    defaultMessage: 'Give me examples of questions I can ask here.'
  }),
  icon: 'sparkles'
}, {
  title: _i18n.i18n.translate('xpack.observabilityAiAssistant.app.starterPrompts.explainThisPage.title', {
    defaultMessage: 'Explain'
  }),
  prompt: _i18n.i18n.translate('xpack.observabilityAiAssistant.app.starterPrompts.explainThisPage.prompt', {
    defaultMessage: 'Can you explain this page?'
  }),
  icon: 'inspect'
}, {
  title: _i18n.i18n.translate('xpack.observabilityAiAssistant.app.starterPrompts.doIHaveAlerts.title', {
    defaultMessage: 'Alerts'
  }),
  prompt: _i18n.i18n.translate('xpack.observabilityAiAssistant.app.starterPrompts.doIHaveAlerts.prompt', {
    defaultMessage: 'Do I have any alerts?'
  }),
  icon: 'bell'
}, {
  title: _i18n.i18n.translate('xpack.observabilityAiAssistant.app.starterPrompts.whatAreSlos.title', {
    defaultMessage: 'SLOs'
  }),
  prompt: _i18n.i18n.translate('xpack.observabilityAiAssistant.app.starterPrompts.whatAreSlos.prompt', {
    defaultMessage: 'What are SLOs?'
  }),
  icon: 'bullseye'
}];