"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useUserPreferredLanguage = useUserPreferredLanguage;
var _i18n = require("@kbn/i18n");
var _react = require("react");
var _language_options = require("../../common/ui_settings/language_options");
var _common = require("../../common");
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useUserPreferredLanguage() {
  const {
    services: {
      uiSettings
    }
  } = (0, _use_kibana.useKibana)();
  const selectedLanguage = uiSettings.get(_common.aiAssistantResponseLanguage, _language_options.DEFAULT_LANGUAGE_OPTION.value);
  const getPreferredLanguage = (0, _react.useCallback)(() => {
    if (selectedLanguage === _language_options.KIBANA_LOCALE_SETTING.value) {
      return getLanguageFromKibanaSettings();
    } else if (selectedLanguage === _language_options.BROWSER_LANGUAGE_SETTING.value) {
      return getLanguageFromBrowserSetting();
    } else {
      return _language_options.languages[selectedLanguage] || 'English';
    }
  }, [selectedLanguage]);
  return {
    selectedLanguage,
    getPreferredLanguage
  };
}
function getLanguageFromKibanaSettings() {
  switch (_i18n.i18n.getLocale()) {
    case 'en':
      return 'English';
    case 'zh-cn':
      return '简体中文';
    case 'ja-jp':
      return '日本語';
    case 'fr-fr':
      return 'français';
    default:
      return 'English';
  }
}
function getLanguageFromBrowserSetting() {
  return _language_options.languages[navigator.language] || 'English';
}