"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.processOpenAiStream = processOpenAiStream;
var _rxjs = require("rxjs");
var _uuid = require("uuid");
var _conversation_complete = require("../conversation_complete");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function processOpenAiStream(logger) {
  return source => {
    const id = (0, _uuid.v4)();
    return source.pipe((0, _rxjs.filter)(line => !!line && line !== '[DONE]'), (0, _rxjs.map)(line => JSON.parse(line)), (0, _rxjs.tap)(line => {
      if ('error' in line) {
        throw (0, _conversation_complete.createInternalServerError)(line.error.message);
      }
      if ('choices' in line && line.choices.length && line.choices[0].finish_reason === 'length') {
        throw (0, _conversation_complete.createTokenLimitReachedError)();
      }
    }), (0, _rxjs.filter)(line => 'object' in line && line.object === 'chat.completion.chunk'), (0, _rxjs.map)(chunk => {
      var _delta$tool_calls$0$f, _delta$tool_calls$0$f2, _delta$content;
      const delta = chunk.choices[0].delta;
      if (delta.tool_calls && delta.tool_calls.length > 1) {
        logger.warn(`More tools than 1 were called: ${JSON.stringify(delta.tool_calls)}`);
      }
      const functionCall = delta.tool_calls ? {
        name: (_delta$tool_calls$0$f = delta.tool_calls[0].function) === null || _delta$tool_calls$0$f === void 0 ? void 0 : _delta$tool_calls$0$f.name,
        arguments: (_delta$tool_calls$0$f2 = delta.tool_calls[0].function) === null || _delta$tool_calls$0$f2 === void 0 ? void 0 : _delta$tool_calls$0$f2.arguments
      } : delta.function_call;
      return {
        id,
        type: _conversation_complete.StreamingChatResponseEventType.ChatCompletionChunk,
        message: {
          content: (_delta$content = delta.content) !== null && _delta$content !== void 0 ? _delta$content : '',
          function_call: functionCall
        }
      };
    }));
  };
}