"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SettingsTab = SettingsTab;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _use_app_context = require("../../../hooks/use_app_context");
var _ui_settings = require("./ui_settings");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SettingsTab() {
  const {
    application: {
      navigateToApp
    }
  } = (0, _use_app_context.useAppContext)();
  const handleNavigateToConnectors = () => {
    navigateToApp('management', {
      path: '/insightsAndAlerting/triggersActionsConnectors/connectors'
    });
  };
  const handleNavigateToSpacesConfiguration = () => {
    navigateToApp('management', {
      path: '/kibana/spaces'
    });
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    fullWidth: true,
    title: /*#__PURE__*/_react.default.createElement("h3", null, _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.settingsPage.showAIAssistantButtonLabel', {
      defaultMessage: 'Show AI Assistant button and Contextual Insights in Observability apps'
    })),
    description: /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.settingsPage.showAIAssistantDescriptionLabel', {
      defaultMessage: 'Toggle the AI Assistant button and Contextual Insights on or off in Observability apps by checking or unchecking the AI Assistant feature in Spaces > <your space> > Features.'
    }))
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "settingsTabGoToSpacesButton",
    onClick: handleNavigateToSpacesConfiguration
  }, _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.settingsPage.goToFeatureControlsButtonLabel', {
    defaultMessage: 'Go to Spaces'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    fullWidth: true,
    title: /*#__PURE__*/_react.default.createElement("h3", null, _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.settingsPage.connectorSettingsLabel', {
      defaultMessage: 'Connector settings'
    })),
    description: _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.settingsPage.euiDescribedFormGroup.inOrderToUseLabel', {
      defaultMessage: 'In order to use the Observability AI Assistant you must set up a Generative AI connector.'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "settingsTabGoToConnectorsButton",
    onClick: handleNavigateToConnectors
  }, _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.settingsPage.goToConnectorsButtonLabel', {
    defaultMessage: 'Manage connectors'
  })))), /*#__PURE__*/_react.default.createElement(_ui_settings.UISettings, null));
}