"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SettingsPage = SettingsPage;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _use_app_context = require("../../hooks/use_app_context");
var _settings_tab = require("./settings_tab/settings_tab");
var _knowledge_base_tab = require("./knowledge_base_tab");
var _use_observability_management_params = require("../../hooks/use_observability_management_params");
var _use_observability_management_router = require("../../hooks/use_observability_management_router");
var _search_connector_tab = require("./search_connector_tab");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SettingsPage() {
  var _tabs$find;
  const {
    application: {
      navigateToApp
    },
    serverless,
    enterpriseSearch,
    setBreadcrumbs
  } = (0, _use_app_context.useAppContext)();
  const router = (0, _use_observability_management_router.useObservabilityAIAssistantManagementRouter)();
  const {
    query: {
      tab
    }
  } = (0, _use_observability_management_params.useObservabilityAIAssistantManagementRouterParams)('/');
  (0, _react.useEffect)(() => {
    if (serverless) {
      serverless.setBreadcrumbs([{
        text: _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.breadcrumb.serverless.observability', {
          defaultMessage: 'AI Assistant for Observability Settings'
        })
      }]);
    } else {
      setBreadcrumbs([{
        text: _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.breadcrumb.index', {
          defaultMessage: 'AI Assistants'
        }),
        onClick: e => {
          e.preventDefault();
          navigateToApp('management', {
            path: '/kibana/aiAssistantManagementSelection'
          });
        }
      }, {
        text: _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.breadcrumb.observability', {
          defaultMessage: 'Observability'
        })
      }]);
    }
  }, [navigateToApp, serverless, setBreadcrumbs]);
  const tabs = [{
    id: 'settings',
    name: _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.settingsPage.settingsLabel', {
      defaultMessage: 'Settings'
    }),
    content: /*#__PURE__*/_react.default.createElement(_settings_tab.SettingsTab, null)
  }, {
    id: 'knowledge_base',
    name: _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.settingsPage.knowledgeBaseLabel', {
      defaultMessage: 'Knowledge base'
    }),
    content: /*#__PURE__*/_react.default.createElement(_knowledge_base_tab.KnowledgeBaseTab, null)
  }, {
    id: 'search_connector',
    name: _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.settingsPage.searchConnector', {
      defaultMessage: 'Search Connectors'
    }),
    content: /*#__PURE__*/_react.default.createElement(_search_connector_tab.SearchConnectorTab, null),
    disabled: enterpriseSearch == null
  }];
  const selectedTabId = tabs.some(t => t.id === tab) ? tab : tabs[0].id;
  const selectedTabContent = (_tabs$find = tabs.find(obj => obj.id === selectedTabId)) === null || _tabs$find === void 0 ? void 0 : _tabs$find.content;
  const onSelectedTabChanged = id => {
    router.push('/', {
      path: '/',
      query: {
        tab: id
      }
    });
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "l"
  }, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.settingsPage.h2.settingsLabel', {
    defaultMessage: 'Settings'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
    "data-test-subj": "settingsPageTabs"
  }, tabs.filter(t => !t.disabled).map((t, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    key: index,
    "data-test-subj": `settingsPageTab-${t.id}`,
    onClick: () => onSelectedTabChanged(t.id),
    isSelected: t.id === selectedTabId
  }, t.name))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), selectedTabContent, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }));
}