"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KnowledgeBaseTab = KnowledgeBaseTab;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _moment = _interopRequireDefault(require("moment"));
var _use_app_context = require("../../hooks/use_app_context");
var _use_get_knowledge_base_entries = require("../../hooks/use_get_knowledge_base_entries");
var _categorize_entries = require("../../helpers/categorize_entries");
var _knowledge_base_edit_manual_entry_flyout = require("./knowledge_base_edit_manual_entry_flyout");
var _knowledge_base_category_flyout = require("./knowledge_base_category_flyout");
var _knowledge_base_bulk_import_flyout = require("./knowledge_base_bulk_import_flyout");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function KnowledgeBaseTab() {
  const {
    uiSettings
  } = (0, _use_app_context.useAppContext)();
  const dateFormat = uiSettings.get('dateFormat');
  const columns = [{
    align: 'right',
    width: '40px',
    isExpander: true,
    name: /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, null, /*#__PURE__*/_react.default.createElement("span", null, _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.span.expandRowLabel', {
      defaultMessage: 'Expand row'
    }))),
    render: category => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        "data-test-subj": "pluginsColumnsButton",
        onClick: () => setSelectedCategory(category),
        "aria-label": category.categoryName === (selectedCategory === null || selectedCategory === void 0 ? void 0 : selectedCategory.categoryName) ? 'Collapse' : 'Expand',
        iconType: category.categoryName === (selectedCategory === null || selectedCategory === void 0 ? void 0 : selectedCategory.categoryName) ? 'minimize' : 'expand'
      });
    }
  }, {
    field: '',
    name: '',
    render: category => {
      if (category.entries.length === 1 && category.entries[0].role === 'user_entry') {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          type: "documentation",
          color: "primary"
        });
      }
      if (category.entries.length === 1 && category.entries[0].role === 'assistant_summarization') {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          type: "sparkles",
          color: "primary"
        });
      }
      return /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "logoElastic"
      });
    },
    width: '40px'
  }, {
    field: 'categoryName',
    name: _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.kbTab.columns.name', {
      defaultMessage: 'Name'
    }),
    sortable: true
  }, {
    name: _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.kbTab.columns.numberOfEntries', {
      defaultMessage: 'Number of entries'
    }),
    width: '140px',
    render: category => {
      if (category.entries.length > 1 && category.entries[0].role === 'elastic') {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, null, category.entries.length);
      }
      return null;
    }
  }, {
    field: '@timestamp',
    name: _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.kbTab.columns.dateCreated', {
      defaultMessage: 'Date created'
    }),
    width: '140px',
    sortable: true,
    render: timestamp => /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "hollow"
    }, (0, _moment.default)(timestamp).format(dateFormat))
  }, {
    name: _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.kbTab.columns.type', {
      defaultMessage: 'Type'
    }),
    width: '140px',
    render: category => {
      if (category.entries.length === 1 && category.entries[0].role === 'user_entry') {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
          color: "hollow"
        }, _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.kbTab.columns.manualBadgeLabel', {
          defaultMessage: 'Manual'
        }));
      }
      if (category.entries.length === 1 && category.entries[0].role === 'assistant_summarization') {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
          color: "hollow"
        }, _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.kbTab.columns.assistantSummarization', {
          defaultMessage: 'Assistant'
        }));
      }
      return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, null, _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.columns.systemBadgeLabel', {
        defaultMessage: 'System'
      }));
    }
  }];
  const [selectedCategory, setSelectedCategory] = (0, _react.useState)();
  const [flyoutOpenType, setFlyoutOpenType] = (0, _react.useState)();
  const [newEntryPopoverOpen, setNewEntryPopoverOpen] = (0, _react.useState)(false);
  const [query, setQuery] = (0, _react.useState)('');
  const [sortBy, setSortBy] = (0, _react.useState)('doc_id');
  const [sortDirection, setSortDirection] = (0, _react.useState)('asc');
  const {
    entries = [],
    isLoading,
    refetch
  } = (0, _use_get_knowledge_base_entries.useGetKnowledgeBaseEntries)({
    query,
    sortBy,
    sortDirection
  });
  const categories = (0, _categorize_entries.categorizeEntries)({
    entries
  });
  const handleChangeSort = ({
    sort
  }) => {
    if (sort) {
      const {
        field,
        direction
      } = sort;
      if (field === '@timestamp') {
        setSortBy(field);
      }
      if (field === 'categoryName') {
        setSortBy('doc_id');
      }
      setSortDirection(direction);
    }
  };
  const handleClickNewEntry = () => {
    setNewEntryPopoverOpen(true);
  };
  const handleChangeQuery = e => {
    setQuery((e === null || e === void 0 ? void 0 : e.currentTarget.value) || '');
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
    "data-test-subj": "knowledgeBaseTabFieldSearch",
    fullWidth: true,
    placeholder: _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.knowledgeBaseTab.euiFieldSearch.searchThisLabel', {
      defaultMessage: 'Search for an entry'
    }),
    value: query,
    onChange: handleChangeQuery,
    isClearable: true,
    "aria-label": _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.knowledgeBaseTab.euiFieldSearch.searchEntriesLabel', {
      defaultMessage: 'Search entries'
    })
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "knowledgeBaseTabReloadButton",
    color: "success",
    iconType: "refresh",
    onClick: () => refetch()
  }, _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.knowledgeBaseTab.reloadButtonLabel', {
    defaultMessage: 'Reload'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    isOpen: newEntryPopoverOpen,
    closePopover: () => setNewEntryPopoverOpen(false),
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      fill: true,
      "data-test-subj": "knowledgeBaseNewEntryButton",
      iconSide: "right",
      iconType: "arrowDown",
      onClick: handleClickNewEntry
    }, _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.knowledgeBaseTab.newEntryButtonLabel', {
      defaultMessage: 'New entry'
    }))
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    size: "s",
    items: [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: "singleEntry",
      icon: "document",
      "data-test-subj": "knowledgeBaseSingleEntryContextMenuItem",
      onClick: () => {
        setNewEntryPopoverOpen(false);
        setFlyoutOpenType('singleEntry');
      },
      size: "s"
    }, _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.knowledgeBaseTab.singleEntryContextMenuItemLabel', {
      defaultMessage: 'Single entry'
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: "bulkImport",
      icon: "documents",
      "data-test-subj": "knowledgeBaseBulkImportContextMenuItem",
      onClick: () => {
        setNewEntryPopoverOpen(false);
        setFlyoutOpenType('bulkImport');
      }
    }, _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.knowledgeBaseTab.bulkImportContextMenuItemLabel', {
      defaultMessage: 'Bulk import'
    }))]
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    "data-test-subj": "knowledgeBaseTable",
    columns: columns,
    items: categories,
    loading: isLoading,
    sorting: {
      sort: {
        field: sortBy === 'doc_id' ? 'categoryName' : sortBy,
        direction: sortDirection
      }
    },
    rowProps: row => ({
      onClick: () => setSelectedCategory(row)
    }),
    onChange: handleChangeSort
  }))), flyoutOpenType === 'singleEntry' ? /*#__PURE__*/_react.default.createElement(_knowledge_base_edit_manual_entry_flyout.KnowledgeBaseEditManualEntryFlyout, {
    onClose: () => setFlyoutOpenType(undefined)
  }) : null, flyoutOpenType === 'bulkImport' ? /*#__PURE__*/_react.default.createElement(_knowledge_base_bulk_import_flyout.KnowledgeBaseBulkImportFlyout, {
    onClose: () => setFlyoutOpenType(undefined)
  }) : null, selectedCategory ? selectedCategory.entries.length === 1 && (selectedCategory.entries[0].role === 'user_entry' || selectedCategory.entries[0].role === 'assistant_summarization') ? /*#__PURE__*/_react.default.createElement(_knowledge_base_edit_manual_entry_flyout.KnowledgeBaseEditManualEntryFlyout, {
    entry: selectedCategory.entries[0],
    onClose: () => setSelectedCategory(undefined)
  }) : /*#__PURE__*/_react.default.createElement(_knowledge_base_category_flyout.KnowledgeBaseCategoryFlyout, {
    category: selectedCategory,
    onClose: () => setSelectedCategory(undefined)
  }) : null);
}