"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KnowledgeBaseEditManualEntryFlyout = KnowledgeBaseEditManualEntryFlyout;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _moment = _interopRequireDefault(require("moment"));
var _use_create_knowledge_base_entry = require("../../hooks/use_create_knowledge_base_entry");
var _use_delete_knowledge_base_entry = require("../../hooks/use_delete_knowledge_base_entry");
var _use_app_context = require("../../hooks/use_app_context");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function KnowledgeBaseEditManualEntryFlyout({
  entry,
  onClose
}) {
  var _entry$id, _entry$text;
  const {
    uiSettings
  } = (0, _use_app_context.useAppContext)();
  const dateFormat = uiSettings.get('dateFormat');
  const {
    mutateAsync: createEntry,
    isLoading
  } = (0, _use_create_knowledge_base_entry.useCreateKnowledgeBaseEntry)();
  const {
    mutateAsync: deleteEntry,
    isLoading: isDeleting
  } = (0, _use_delete_knowledge_base_entry.useDeleteKnowledgeBaseEntry)();
  const [newEntryId, setNewEntryId] = (0, _react.useState)((_entry$id = entry === null || entry === void 0 ? void 0 : entry.id) !== null && _entry$id !== void 0 ? _entry$id : '');
  const [newEntryText, setNewEntryText] = (0, _react.useState)((_entry$text = entry === null || entry === void 0 ? void 0 : entry.text) !== null && _entry$text !== void 0 ? _entry$text : '');
  const isEntryIdInvalid = newEntryId.trim() === '';
  const isEntryTextInvalid = newEntryText.trim() === '';
  const isFormInvalid = isEntryIdInvalid || isEntryTextInvalid;
  const handleSubmitNewEntryClick = async () => {
    createEntry({
      entry: {
        id: newEntryId,
        text: newEntryText
      }
    }).then(onClose);
  };
  const handleDelete = async () => {
    await deleteEntry({
      id: entry.id
    });
    onClose();
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: onClose
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    "data-test-subj": "knowledgeBaseManualEntryFlyout"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", null, !entry ? _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.knowledgeBaseNewEntryFlyout.h2.newEntryLabel', {
    defaultMessage: 'New entry'
  }) : _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.knowledgeBaseNewEntryFlyout.h2.editEntryLabel', {
    defaultMessage: 'Edit {id}',
    values: {
      id: entry.id
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, !entry ? /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.knowledgeBaseEditManualEntryFlyout.euiFormRow.idLabel', {
      defaultMessage: 'Name'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    "data-test-subj": "knowledgeBaseEditManualEntryFlyoutIdInput",
    fullWidth: true,
    value: newEntryId,
    onChange: e => setNewEntryId(e.target.value),
    isInvalid: isEntryIdInvalid
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.knowledgeBaseEditManualEntryFlyout.createdOnTextLabel', {
    defaultMessage: 'Created on'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, (0, _moment.default)(entry['@timestamp']).format(dateFormat))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "knowledgeBaseEditManualEntryFlyoutDeleteEntryButton",
    color: "danger",
    iconType: "trash",
    isLoading: isDeleting,
    onClick: handleDelete
  }, _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.knowledgeBaseEditManualEntryFlyout.deleteEntryButtonLabel', {
    defaultMessage: 'Delete entry'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.knowledgeBaseEditManualEntryFlyout.euiFormRow.contentsLabel', {
      defaultMessage: 'Contents'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiMarkdownEditor, {
    editorId: "knowledgeBaseEditManualEntryFlyoutMarkdownEditor",
    "aria-label": _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.knowledgeBaseNewManualEntryFlyout.euiMarkdownEditor.observabilityAiAssistantKnowledgeBaseViewMarkdownEditorLabel', {
      defaultMessage: 'observabilityAiAssistantKnowledgeBaseViewMarkdownEditor'
    }),
    height: 300,
    initialViewMode: "editing",
    readOnly: false,
    placeholder: _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.knowledgeBaseEditManualEntryFlyout.euiMarkdownEditor.enterContentsLabel', {
      defaultMessage: 'Enter contents'
    }),
    value: newEntryText,
    onChange: text => setNewEntryText(text)
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "knowledgeBaseEditManualEntryFlyoutCancelButton",
    disabled: isLoading,
    onClick: onClose
  }, _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.knowledgeBaseNewManualEntryFlyout.cancelButtonEmptyLabel', {
    defaultMessage: 'Cancel'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "knowledgeBaseEditManualEntryFlyoutSaveButton",
    fill: true,
    isLoading: isLoading,
    onClick: handleSubmitNewEntryClick,
    isDisabled: isFormInvalid
  }, _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.knowledgeBaseNewManualEntryFlyout.saveButtonLabel', {
    defaultMessage: 'Save'
  }))))));
}