"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AiAssistantManagementObservabilityPlugin = void 0;
var _i18n = require("@kbn/i18n");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// eslint-disable-next-line @typescript-eslint/no-empty-interface

// eslint-disable-next-line @typescript-eslint/no-empty-interface

class AiAssistantManagementObservabilityPlugin {
  setup(core, {
    home,
    management,
    observabilityAIAssistant
  }) {
    const title = _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.app.title', {
      defaultMessage: 'AI Assistant for Observability'
    });
    if (home) {
      home.featureCatalogue.register({
        id: 'ai_assistant_observability',
        title,
        description: _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.app.description', {
          defaultMessage: 'Manage your AI Assistant for Observability.'
        }),
        icon: 'sparkles',
        path: '/app/management/kibana/ai-assistant/observability',
        showOnHomePage: false,
        category: 'admin'
      });
    }
    if (observabilityAIAssistant) {
      management.sections.section.kibana.registerApp({
        id: 'observabilityAiAssistantManagement',
        title,
        hideFromSidebar: true,
        order: 1,
        mount: async mountParams => {
          const {
            mountManagementSection
          } = await Promise.resolve().then(() => _interopRequireWildcard(require('./app')));
          return mountManagementSection({
            core,
            mountParams
          });
        }
      });
    }
    return {};
  }
  start() {
    return {};
  }
}
exports.AiAssistantManagementObservabilityPlugin = AiAssistantManagementObservabilityPlugin;