"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ObservabilityAIAssistantAppPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = require("lodash");
var _rxjs = require("rxjs");
var _functions = require("./functions");
var _rule_connector = require("./rule_connector");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ObservabilityAIAssistantAppPlugin {
  constructor(context) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    this.logger = context.logger.get();
  }
  setup(core, plugins) {
    const routeHandlerPlugins = (0, _lodash.mapValues)(plugins, (value, key) => {
      return {
        setup: value,
        start: () => core.getStartServices().then(services => {
          const [, pluginsStartContracts] = services;
          return pluginsStartContracts[key];
        })
      };
    });
    const initResources = async request => {
      const [coreStart, pluginsStart] = await core.getStartServices();
      const license = await (0, _rxjs.firstValueFrom)(pluginsStart.licensing.license$);
      const savedObjectsClient = coreStart.savedObjects.getScopedClient(request);
      const context = {
        rac: routeHandlerPlugins.ruleRegistry.start().then(startContract => {
          return {
            getAlertsClient() {
              return startContract.getRacClientWithRequest(request);
            }
          };
        }),
        alerting: routeHandlerPlugins.alerting.start().then(startContract => {
          return {
            getRulesClient() {
              return startContract.getRulesClientWithRequest(request);
            }
          };
        }),
        core: Promise.resolve({
          coreStart,
          elasticsearch: {
            client: coreStart.elasticsearch.client.asScoped(request)
          },
          uiSettings: {
            client: coreStart.uiSettings.asScopedToClient(savedObjectsClient),
            globalClient: coreStart.uiSettings.globalAsScopedToClient(savedObjectsClient)
          },
          savedObjects: {
            client: savedObjectsClient
          }
        }),
        licensing: Promise.resolve({
          license,
          featureUsage: pluginsStart.licensing.featureUsage
        })
      };
      return {
        request,
        context,
        service: plugins.observabilityAIAssistant.service,
        logger: this.logger.get('connector'),
        plugins: routeHandlerPlugins
      };
    };
    plugins.actions.registerType((0, _rule_connector.getObsAIAssistantConnectorType)(initResources, plugins.observability.alertDetailsContextualInsightsService));
    plugins.alerting.registerConnectorAdapter((0, _rule_connector.getObsAIAssistantConnectorAdapter)());
    return {};
  }
  start(core, pluginsStart) {
    pluginsStart.observabilityAIAssistant.service.register(params => {
      return (0, _functions.registerFunctions)({
        ...params,
        pluginsStart
      });
    });
    return {};
  }
}
exports.ObservabilityAIAssistantAppPlugin = ObservabilityAIAssistantAppPlugin;