"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerVisualizeESQLFunction = registerVisualizeESQLFunction;
var _visualize_esql = require("@kbn/observability-ai-assistant-plugin/common/functions/visualize_esql");
var _visualize_esql2 = require("../../common/functions/visualize_esql");
var _validate_esql_query = require("./query/validate_esql_query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getMessageForLLM = (intention, query, hasErrors) => {
  if (hasErrors) {
    return 'The query has syntax errors';
  }
  return intention === _visualize_esql.VisualizeESQLUserIntention.executeAndReturnResults || intention === _visualize_esql.VisualizeESQLUserIntention.generateQueryOnly ? 'These results are not visualized' : 'Only following query is visualized: ```esql\n' + query + '\n```';
};
function registerVisualizeESQLFunction({
  functions,
  resources
}) {
  functions.registerFunction(_visualize_esql2.visualizeESQLFunction, async ({
    arguments: {
      query,
      intention
    }
  }) => {
    const {
      columns,
      errorMessages
    } = await (0, _validate_esql_query.validateEsqlQuery)({
      query,
      client: (await resources.context.core).elasticsearch.client.asCurrentUser
    });
    const message = getMessageForLLM(intention, query, Boolean(errorMessages === null || errorMessages === void 0 ? void 0 : errorMessages.length));
    return {
      data: {
        columns
      },
      content: {
        message,
        errorMessages
      }
    };
  });
}