"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SharedProviders = SharedProviders;
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _reactKibanaContextTheme = require("@kbn/react-kibana-context-theme");
var _sharedUxLinkRedirectApp = require("@kbn/shared-ux-link-redirect-app");
var _react = _interopRequireWildcard(require("react"));
var _observability_ai_assistant_app_service_provider = require("../context/observability_ai_assistant_app_service_provider");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SharedProviders({
  children,
  coreStart,
  pluginsStart,
  service,
  theme$
}) {
  const theme = (0, _react.useMemo)(() => {
    return {
      theme$
    };
  }, [theme$]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiErrorBoundary, null, /*#__PURE__*/_react.default.createElement(_reactKibanaContextTheme.KibanaThemeProvider, {
    theme: theme
  }, /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
    services: {
      ...coreStart,
      ...pluginsStart,
      plugins: {
        start: pluginsStart
      }
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxLinkRedirectApp.RedirectAppLinks, {
    coreStart: coreStart
  }, /*#__PURE__*/_react.default.createElement(coreStart.i18n.Context, null, /*#__PURE__*/_react.default.createElement(_observability_ai_assistant_app_service_provider.ObservabilityAIAssistantAppServiceProvider, {
    value: service
  }, children))))));
}