"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTimelineItemsfromConversation = getTimelineItemsfromConversation;
var _react = _interopRequireDefault(require("react"));
var _uuid = require("uuid");
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/observability-ai-assistant-plugin/public");
var _render_function = require("../components/render_function");
var _safe_json_parse = require("./safe_json_parse");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function convertMessageToMarkdownCodeBlock(message) {
  let value;
  if (!message.name) {
    var _message$function_cal, _message$function_cal2;
    const name = (_message$function_cal = message.function_call) === null || _message$function_cal === void 0 ? void 0 : _message$function_cal.name;
    const args = (_message$function_cal2 = message.function_call) !== null && _message$function_cal2 !== void 0 && _message$function_cal2.arguments ? (0, _safe_json_parse.safeJsonParse)(message.function_call.arguments) : undefined;
    value = {
      name,
      args
    };
  } else {
    const content = message.role !== _public.MessageRole.Assistant && message.content ? (0, _safe_json_parse.safeJsonParse)(message.content) : message.content;
    const data = message.data ? (0, _safe_json_parse.safeJsonParse)(message.data) : undefined;
    value = (0, _lodash.omitBy)({
      content,
      data
    }, _lodash.isEmpty);
  }
  return `\`\`\`\n${JSON.stringify(value, null, 2)}\n\`\`\``;
}
function FunctionName({
  name: functionName
}) {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement("span", {
    style: {
      fontFamily: euiTheme.font.familyCode,
      fontSize: 13
    }
  }, functionName);
}
function getTimelineItemsfromConversation({
  chatService,
  currentUser,
  hasConnector,
  messages,
  chatState,
  onActionClick
}) {
  var _lastMessage, _lastMessage$message$;
  const messagesWithoutSystem = messages.filter(message => message.message.role !== _public.MessageRole.System);
  const items = [{
    id: (0, _uuid.v4)(),
    actions: {
      canCopy: false,
      canEdit: false,
      canGiveFeedback: false,
      canRegenerate: false
    },
    display: {
      collapsed: false,
      hide: false
    },
    currentUser,
    loading: false,
    message: {
      '@timestamp': new Date().toISOString(),
      message: {
        role: _public.MessageRole.User
      }
    },
    title: _i18n.i18n.translate('xpack.observabilityAiAssistant.conversationStartTitle', {
      defaultMessage: 'started a conversation'
    }),
    role: _public.MessageRole.User
  }, ...messagesWithoutSystem.map((message, index) => {
    var _message$message$func, _message$message$func2;
    const id = (0, _uuid.v4)();
    let title = '';
    let content;
    let element;
    const prevFunctionCall = message.message.name && messagesWithoutSystem[index - 1] && messagesWithoutSystem[index - 1].message.function_call ? messagesWithoutSystem[index - 1].message.function_call : undefined;
    let role = ((_message$message$func = message.message.function_call) === null || _message$message$func === void 0 ? void 0 : _message$message$func.trigger) || message.message.role;
    const actions = {
      canCopy: false,
      canEdit: false,
      canGiveFeedback: false,
      canRegenerate: false
    };
    const display = {
      collapsed: false,
      hide: false
    };
    switch (role) {
      case _public.MessageRole.User:
        actions.canCopy = true;
        actions.canGiveFeedback = false;
        actions.canRegenerate = false;
        display.hide = false;

        // User executed a function:
        if (message.message.name && prevFunctionCall) {
          let isError = false;
          try {
            var _message$message$cont;
            const parsedContent = JSON.parse((_message$message$cont = message.message.content) !== null && _message$message$cont !== void 0 ? _message$message$cont : 'null');
            isError = parsedContent && typeof parsedContent === 'object' && 'error' in parsedContent;
          } catch (error) {
            isError = true;
          }
          title = !isError ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.observabilityAiAssistant.userExecutedFunctionEvent",
            defaultMessage: "executed the function {functionName}",
            values: {
              functionName: /*#__PURE__*/_react.default.createElement(FunctionName, {
                name: message.message.name
              })
            }
          }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.observabilityAiAssistant.executedFunctionFailureEvent",
            defaultMessage: "failed to execute the function {functionName}",
            values: {
              functionName: /*#__PURE__*/_react.default.createElement(FunctionName, {
                name: message.message.name
              })
            }
          });
          element = !isError && chatService.hasRenderFunction(message.message.name) ? /*#__PURE__*/_react.default.createElement(_render_function.RenderFunction, {
            name: message.message.name,
            arguments: prevFunctionCall === null || prevFunctionCall === void 0 ? void 0 : prevFunctionCall.arguments,
            response: message.message,
            onActionClick: payload => {
              onActionClick({
                message,
                payload
              });
            }
          }) : undefined;
          content = !element ? convertMessageToMarkdownCodeBlock(message.message) : undefined;
          if ((prevFunctionCall === null || prevFunctionCall === void 0 ? void 0 : prevFunctionCall.trigger) === _public.MessageRole.Assistant) {
            role = _public.MessageRole.Assistant;
          }
          actions.canEdit = false;
          display.collapsed = !element;
        } else if (message.message.function_call) {
          // User suggested a function
          title = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.observabilityAiAssistant.userSuggestedFunctionEvent",
            defaultMessage: "requested the function {functionName}",
            values: {
              functionName: /*#__PURE__*/_react.default.createElement(FunctionName, {
                name: message.message.function_call.name
              })
            }
          });
          content = convertMessageToMarkdownCodeBlock(message.message);
          actions.canEdit = hasConnector;
          display.collapsed = true;
        } else {
          // is a prompt by the user
          title = '';
          content = message.message.content;
          actions.canEdit = hasConnector;
          display.collapsed = false;
        }
        break;
      case _public.MessageRole.Assistant:
        actions.canRegenerate = hasConnector;
        actions.canCopy = true;
        actions.canGiveFeedback = true;
        display.hide = false;

        // is a function suggestion by the assistant
        if ((_message$message$func2 = message.message.function_call) !== null && _message$message$func2 !== void 0 && _message$message$func2.name) {
          title = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.observabilityAiAssistant.suggestedFunctionEvent",
            defaultMessage: "requested the function {functionName}",
            values: {
              functionName: /*#__PURE__*/_react.default.createElement(FunctionName, {
                name: message.message.function_call.name
              })
            }
          });
          if (message.message.content) {
            // TODO: we want to show the content always, and hide
            // the function request initially, but we don't have a
            // way to do that yet, so we hide the request here until
            // we have a fix.
            // element = message.message.content;
            content = message.message.content;
            display.collapsed = false;
          } else {
            content = convertMessageToMarkdownCodeBlock(message.message);
            display.collapsed = true;
          }
          actions.canEdit = true;
        } else {
          // is an assistant response
          title = '';
          content = message.message.content;
          display.collapsed = false;
          actions.canEdit = false;
        }
        break;
    }
    return {
      id,
      role,
      title,
      content,
      element,
      actions,
      display,
      currentUser,
      function_call: message.message.function_call,
      loading: false,
      message
    };
  })];
  const isLoading = chatState === _public.ChatState.Loading;
  let lastMessage = (0, _lodash.last)(items);
  const isNaturalLanguageOnlyAnswerFromAssistant = ((_lastMessage = lastMessage) === null || _lastMessage === void 0 ? void 0 : _lastMessage.message.message.role) === _public.MessageRole.Assistant && !((_lastMessage$message$ = lastMessage.message.message.function_call) !== null && _lastMessage$message$ !== void 0 && _lastMessage$message$.name);
  const addLoadingPlaceholder = isLoading && !isNaturalLanguageOnlyAnswerFromAssistant;
  if (addLoadingPlaceholder) {
    items.push({
      id: (0, _uuid.v4)(),
      actions: {
        canCopy: false,
        canEdit: false,
        canGiveFeedback: false,
        canRegenerate: false
      },
      display: {
        collapsed: false,
        hide: false
      },
      content: '',
      currentUser,
      loading: chatState === _public.ChatState.Loading,
      role: _public.MessageRole.Assistant,
      title: '',
      message: {
        '@timestamp': new Date().toISOString(),
        message: {
          role: _public.MessageRole.Assistant,
          content: ''
        }
      }
    });
    lastMessage = (0, _lodash.last)(items);
  }
  if (isLoading && lastMessage) {
    lastMessage.loading = isLoading;
  }
  return items;
}